/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.wizards.datasource;

import java.util.HashMap;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.local.LocalDirectoryRepository;
import org.palladiosimulator.edp2.local.localFactory;
import org.palladiosimulator.edp2.local.localPackage;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.ui.wizards.datasource.FileSystemButtonSelectionAdater;
import org.palladiosimulator.edp2.ui.wizards.datasource.WorkspaceButtonSelectionAdapter;

public class DiscoverLocalDirectoryPage
extends WizardPage {
    private static final HashMap<Control, ControlDecoration> DECORATOR_MAP = new HashMap();
    private final LocalDirectoryRepository ldRepo = localFactory.eINSTANCE.createLocalDirectoryRepository();

    public DiscoverLocalDirectoryPage() {
        super("wizardPage");
        this.setTitle("Discover Local File Data Source");
        this.setDescription("Please select the data source you want to open.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        Text locationText = new Text(container, 2048);
        this.createDirectoryInputSection(container, "Location: ", locationText);
        this.createControlDecoration((Control)locationText);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(10, 5).generateLayout(container);
        final DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        ISWTObservableValue observeLocationText = WidgetProperties.text((int)24).observe((Widget)locationText);
        dbc.bindValue((IObservableValue)observeLocationText, EMFObservables.observeValue((EObject)this.ldRepo, (EStructuralFeature)localPackage.Literals.LOCAL_DIRECTORY_REPOSITORY__URI), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new UriPointsToLocalDirectoryValidator("location", this.ldRepo)), null);
        final AggregateValidationStatus aggregateValidationStatus = new AggregateValidationStatus((IObservableCollection)dbc.getValidationStatusProviders(), 2);
        aggregateValidationStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                aggregateValidationStatus.getValue();
                for (Object o : dbc.getBindings()) {
                    ControlDecoration decoration;
                    Binding binding = (Binding)o;
                    IStatus status = (IStatus)binding.getValidationStatus().getValue();
                    Control control = null;
                    if (binding.getTarget() instanceof ISWTObservable) {
                        ISWTObservable swtObservable = (ISWTObservable)binding.getTarget();
                        control = (Control)swtObservable.getWidget();
                    }
                    if ((decoration = DECORATOR_MAP.get(control)) == null) continue;
                    if (status.isOK()) {
                        decoration.hide();
                        DiscoverLocalDirectoryPage.this.setPageComplete(true);
                        continue;
                    }
                    decoration.setDescriptionText(status.getMessage());
                    decoration.show();
                }
            }
        });
    }

    private void createControlDecoration(Control control) {
        ControlDecoration controlDecoration = new ControlDecoration(control, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        DECORATOR_MAP.put(control, controlDecoration);
    }

    public void createDirectoryInputSection(Composite container, String modelFileLabel, Text textFileNameToLoad) {
        Group fileInputGroup = new Group(container, 0);
        GridLayout glFileInputGroup = new GridLayout();
        glFileInputGroup.numColumns = 3;
        fileInputGroup.setLayout((Layout)glFileInputGroup);
        fileInputGroup.setText(modelFileLabel);
        fileInputGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        textFileNameToLoad.setParent((Composite)fileInputGroup);
        GridData gd_textFileName = new GridData(4, 0x1000000, true, false);
        gd_textFileName.widthHint = 200;
        textFileNameToLoad.setLayoutData((Object)gd_textFileName);
        Button workspaceButton = new Button((Composite)fileInputGroup, 0);
        workspaceButton.setText("Workspace...");
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionAdapter(this.getShell(), textFileNameToLoad));
        Button buttonUsage = new Button((Composite)fileInputGroup, 0);
        buttonUsage.setText("File System...");
        buttonUsage.addSelectionListener((SelectionListener)new FileSystemButtonSelectionAdater(this.getShell(), textFileNameToLoad));
    }

    public Repository getRepositoryOnFinish() {
        return this.ldRepo;
    }

    public static class NotEmptyValidator
    implements IValidator {
        private final String label;

        public NotEmptyValidator(String label) {
            this.label = label;
        }

        public IStatus validate(Object value) {
            String string = (String)value;
            if (string == null || string.trim().length() == 0) {
                return ValidationStatus.error((String)("Please enter a value for " + this.label + "."));
            }
            return ValidationStatus.ok();
        }
    }

    public static class UriPointsToLocalDirectoryValidator
    implements IValidator {
        private final String label;
        private final LocalDirectoryRepository ldRepo;

        public UriPointsToLocalDirectoryValidator(String label, LocalDirectoryRepository ldRepo) {
            this.label = label;
            this.ldRepo = ldRepo;
        }

        public IStatus validate(Object value) {
            String input = (String)value;
            if (input == null || input.trim().length() == 0) {
                return ValidationStatus.error((String)("Please enter a value for " + this.label + "."));
            }
            try {
                this.ldRepo.convertUriStringToFile(input);
            }
            catch (DataNotAccessibleException e1) {
                return ValidationStatus.error((String)("The value entered in " + this.label + " is not valid: " + e1.getMessage()));
            }
            return ValidationStatus.ok();
        }
    }
}

