/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.util;

import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.util.visitors.BaseMetricFromMetricSwitch;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.CaptureType;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.TextualBaseMetricDescription;

public final class MetricDescriptionUtility {
    private MetricDescriptionUtility() {
    }

    public static boolean metricDescriptionIdsEqual(MetricDescription first, MetricDescription second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("Either of the given instances is null.");
        }
        return first.getId().equals(second.getId());
    }

    public static <T extends Quantity> Unit<T> getDefaultUnit(NumericalBaseMetricDescription baseMetric, Class<T> quantityDimension) {
        if (baseMetric == null || quantityDimension == null) {
            throw new IllegalAccessError("Both arguments must not be null.");
        }
        return baseMetric.getDefaultUnit().asType(quantityDimension);
    }

    public static boolean isBaseMetricDescriptionSubsumedByMetricDescription(BaseMetricDescription soughtFor, MetricDescription description) {
        BaseMetricDescription[] baseMetricDescriptionArray = MetricDescriptionUtility.toBaseMetricDescriptions(description);
        int n = baseMetricDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetricDescription baseMetric = baseMetricDescriptionArray[n2];
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)soughtFor, (MetricDescription)baseMetric)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static BaseMetricDescription[] toBaseMetricDescriptions(MetricDescription description) {
        return (BaseMetricDescription[])new BaseMetricFromMetricSwitch().doSwitch((EObject)description);
    }

    public static boolean isValidValue(BaseMetricDescription description, Object value) {
        if (description.getCaptureType() == CaptureType.IDENTIFIER) {
            if (value instanceof Measure && ((Measure)value).getValue() instanceof Identifier) {
                boolean isDefinedAtMetric = false;
                for (Identifier ident : ((TextualBaseMetricDescription)description).getIdentifiers()) {
                    if (!ident.getId().equals(((Identifier)((Measure)value).getValue()).getId())) continue;
                    isDefinedAtMetric = true;
                    break;
                }
                if (!isDefinedAtMetric) {
                    throw new IllegalArgumentException("The provided identifier " + value + " does not exists for the metric " + description + ".");
                }
                return true;
            }
            return false;
        }
        return value instanceof Measure;
    }
}

