/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.util.visitors;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.dao.Edp2Dao;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDaoRegistry;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataSwitch;

public class EmfmodelAddMeasurementToDataSeriesSwitch
extends ExperimentDataSwitch<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(EmfmodelAddMeasurementToDataSeriesSwitch.class.getCanonicalName());
    private final MeasurementsDaoRegistry daoRegistry;
    private Measure<?, ?> measurementToAdd;

    public EmfmodelAddMeasurementToDataSeriesSwitch(MeasurementsDaoRegistry daoRegistry) {
        this.daoRegistry = daoRegistry;
    }

    private static boolean openDaoForDataSeries(Edp2Dao dao, DataSeries dataSeries) {
        if (!dao.isOpen()) {
            try {
                dao.open();
            }
            catch (DataNotAccessibleException e) {
                LOGGER.log(Level.SEVERE, "Could not access DAO with valuesUuid=" + dataSeries.getValuesUuid());
                return false;
            }
        }
        return true;
    }

    private <V, Q extends Quantity> MeasurementsDao<V, Q> getMeasurementsDaoByValuesUuid(String valuesUuid) {
        MeasurementsDao dao;
        MeasurementsDao result = dao = this.daoRegistry.getMeasurementsDao(valuesUuid);
        return result;
    }

    public Boolean caseIdentifierBasedMeasurements(IdentifierBasedMeasurements object) {
        MeasurementsDao dao = this.getMeasurementsDaoByValuesUuid(object.getValuesUuid());
        if (!EmfmodelAddMeasurementToDataSeriesSwitch.openDaoForDataSeries(dao, (DataSeries)object)) {
            return false;
        }
        Measure<?, ?> measurement = this.measurementToAdd;
        dao.getMeasurements().add(measurement);
        return true;
    }

    public Boolean caseJSXmlMeasurements(JSXmlMeasurements object) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <Q extends Quantity> Boolean caseDoubleBinaryMeasurements(DoubleBinaryMeasurements<Q> object) {
        Measure measureToAdd;
        MeasurementsDao dao = this.getMeasurementsDaoByValuesUuid(object.getValuesUuid());
        if (dao == null) {
            throw new RuntimeException("Could not find DoubleBinaryMeasurement with unit " + object.getStorageUnit().toString() + " (ID " + object.getValuesUuid() + ")");
        }
        if (!EmfmodelAddMeasurementToDataSeriesSwitch.openDaoForDataSeries(dao, object)) {
            return false;
        }
        Unit storageUnit = object.getStorageUnit();
        if (!storageUnit.equals((Object)(measureToAdd = this.measurementToAdd).getUnit())) {
            measureToAdd = Measure.valueOf((double)measureToAdd.doubleValue(storageUnit), (Unit)storageUnit);
        }
        dao.getMeasurements().add(measureToAdd);
        return true;
    }

    public Boolean caseLongBinaryMeasurements(LongBinaryMeasurements object) {
        Measure measureToAdd;
        MeasurementsDao dao = this.getMeasurementsDaoByValuesUuid(object.getValuesUuid());
        if (!EmfmodelAddMeasurementToDataSeriesSwitch.openDaoForDataSeries(dao, (DataSeries)object)) {
            return false;
        }
        Unit storageUnit = object.getStorageUnit();
        if (!storageUnit.equals((Object)(measureToAdd = this.measurementToAdd).getUnit())) {
            measureToAdd = Measure.valueOf((long)measureToAdd.longValue(storageUnit), (Unit)storageUnit);
        }
        dao.getMeasurements().add(measureToAdd);
        return true;
    }

    public Object getMeasurementToAdd() {
        return this.measurementToAdd;
    }

    public void setMeasurementToAdd(Measure<?, ?> measurementToAdd) {
        this.measurementToAdd = measurementToAdd;
    }
}

