/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.properties.sections;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;
import org.palladiosimulator.edp2.datastream.filter.IFilter;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.Activator;
import org.palladiosimulator.edp2.visualization.IVisualisationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.editors.AbstractEditor;
import org.palladiosimulator.edp2.visualization.properties.sections.EDP2PropertiesTable;
import org.palladiosimulator.edp2.visualization.properties.sections.InputSelectionTree;
import org.palladiosimulator.edp2.visualization.wizards.AdapterWizard;
import org.palladiosimulator.edp2.visualization.wizards.FilterWizard;

public class TransformationsPropertySection
extends AbstractPropertySection
implements ISelectionChangedListener {
    private TreeViewer treeViewer;
    private EDP2PropertiesTable transformationTable;
    private AbstractEditor<AbstractVisualizationSingleDatastreamInput> editor;
    private IDataSource selectedAdapter;
    private IVisualisationSingleDatastreamInput selectedInput;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite container = this.getWidgetFactory().createFlatFormComposite(parent);
        container.setBackground(parent.getDisplay().getSystemColor(22));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        Group group = new Group(container, 0);
        group.setText("Editor Inputs");
        group.setLayout((Layout)new GridLayout(3, false));
        InputSelectionTree tree = new InputSelectionTree((Composite)group, 0x1000000, null);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        tree.setLayoutData(gridData);
        this.treeViewer = tree.getTreeViewer();
        this.initTransformationTable((Composite)group);
        Button buttonAdapter = new Button((Composite)group, 8);
        buttonAdapter.setText("Add new Adapter..");
        gridData = new GridData(4, 4, false, false, 1, 1);
        gridData.widthHint = 120;
        buttonAdapter.setLayoutData((Object)gridData);
        Button buttonFilter = new Button((Composite)group, 8);
        buttonFilter.setText("Add new Filter..");
        buttonFilter.setLayoutData((Object)gridData);
        this.initializeButtonListeners(buttonAdapter, buttonFilter);
    }

    private void initializeButtonListeners(final Button buttonAdapter, final Button buttonFilter) {
        Listener btnListener = new Listener(){

            public void handleEvent(Event event) {
                if (TransformationsPropertySection.this.selectedInput == null) {
                    MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No data series selected", (String)"To add a transformation, a data series, to which the transformation should be added, must be selected first");
                } else {
                    boolean updateEditorContents = false;
                    if (event.widget == buttonAdapter) {
                        AbstractAdapter adapter;
                        AdapterWizard wizard = new AdapterWizard((AbstractDataSource)TransformationsPropertySection.this.selectedInput.getDataSource());
                        WizardDialog wdialog = new WizardDialog(Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                        wdialog.open();
                        if (wdialog.getReturnCode() == 0 && (adapter = wizard.getAdapter()) != null) {
                            TransformationsPropertySection.this.handleSemanticChange(adapter);
                            updateEditorContents = true;
                        }
                    } else if (event.widget == buttonFilter) {
                        IFilter filter;
                        FilterWizard wizard = new FilterWizard((AbstractDataSource)TransformationsPropertySection.this.selectedInput.getDataSource());
                        WizardDialog wdialog = new WizardDialog(Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                        wdialog.open();
                        if (wdialog.getReturnCode() == 0 && (filter = wizard.getFilter()) != null) {
                            TransformationsPropertySection.this.selectedInput.setDataSource((IDataSource)filter);
                            TransformationsPropertySection.this.refresh();
                            updateEditorContents = true;
                        }
                    }
                    if (updateEditorContents && TransformationsPropertySection.this.editor != null) {
                        TransformationsPropertySection.this.editor.updateEditorContents();
                        TransformationsPropertySection.this.editor.visualisationInputChanged(true);
                    }
                }
            }
        };
        buttonAdapter.addListener(13, btnListener);
        buttonFilter.addListener(13, btnListener);
    }

    private void handleSemanticChange(AbstractAdapter adapter) {
    }

    private void initTransformationTable(Composite parent) {
        this.transformationTable = new EDP2PropertiesTable(parent);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
    }

    private boolean editorExists() {
        IEditorPart activeEditor;
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        this.editor = null;
        if (window != null && window.getActivePage() != null && (activeEditor = window.getActivePage().getActiveEditor()) != null) {
            AbstractEditor activeAbstractEditor;
            this.editor = activeAbstractEditor = (AbstractEditor)activeEditor;
        }
        return this.editor != null;
    }

    private void refreshPropertiesTable() {
        this.transformationTable.refreshTable();
    }

    public void refresh() {
        if (this.editorExists()) {
            this.treeViewer.setInput((Object)this.editor.getEditorInput());
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.treeViewer.refresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ITreeSelection selection = (ITreeSelection)event.getSelectionProvider().getSelection();
        this.handleNewSelection(selection);
    }

    private void handleNewSelection(ITreeSelection selection) {
        if (selection.getFirstElement() instanceof IDataSource) {
            this.selectedAdapter = (IDataSource)selection.getFirstElement();
            this.transformationTable.setLastSelection(this.selectedAdapter.getConfiguration());
            this.refreshPropertiesTable();
        } else {
            this.selectedInput = (IVisualisationSingleDatastreamInput)selection.getFirstElement();
            this.transformationTable.setLastSelection(null);
        }
    }
}

