/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.filter.IFilter;
import org.palladiosimulator.edp2.visualization.wizards.FilterWizard;
import org.palladiosimulator.edp2.visualization.wizards.IFilterWizard;

public class SelectFilterPage
extends WizardPage
implements ISelectionChangedListener {
    private static final Logger LOGGER = Logger.getLogger(SelectFilterPage.class.getCanonicalName());
    private static final String FILTER_EXTENSION_POINT_ID = "org.palladiosimulator.edp2.visualization.filter";
    private static final String FILTER_CLASS_ATTRIBUTE = "class";
    private static final String FILTER_WIZARD_ATTRIBUTE = "wizard";
    private static final String FILTER_NAME = "name";
    private final AbstractDataSource selectedSource;
    private IStatus selectionStatus;
    private final Status statusOK;
    private IFilterWizard selectedFilterWizard;

    protected SelectFilterPage(String pageName, AbstractDataSource selectedSource) {
        super(pageName);
        this.selectedSource = selectedSource;
        this.setDescription("Select the Filter you wish to add.");
        this.statusOK = new Status(0, "not_used", 0, "", null);
        this.selectionStatus = this.statusOK;
    }

    public boolean canFlipToNextPage() {
        return this.updatePageStatus().isOK() && this.selectedFilterWizard != null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText("Available Filters:");
        SashForm sashForm = new SashForm(composite, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        sashForm.setLayoutData((Object)gd);
        this.initializeFilterTableViewer(sashForm);
        this.setControl((Control)composite);
        this.updatePageStatus();
    }

    private void initializeFilterTableViewer(SashForm sashForm) {
        TableViewer filterViewer = new TableViewer((Composite)sashForm, 2048);
        filterViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SelectFilterPage.this.getApplicableFilters(SelectFilterPage.this.selectedSource).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        filterViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null) {
                    return ((IWizard)element).getWindowTitle();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        filterViewer.setInput(this.getApplicableFilters(this.selectedSource));
        filterViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected List<IFilterWizard> getApplicableFilters(AbstractDataSource forSource) {
        IConfigurationElement[] filterExtensions;
        ArrayList<IFilterWizard> availableFilters = new ArrayList<IFilterWizard>();
        IConfigurationElement[] iConfigurationElementArray = filterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(FILTER_EXTENSION_POINT_ID);
        int n = filterExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Object o = null;
            try {
                Object w = e.createExecutableExtension(FILTER_WIZARD_ATTRIBUTE);
                o = e.createExecutableExtension(FILTER_CLASS_ATTRIBUTE);
                if (((IFilter)o).canAccept((IDataSource)forSource)) {
                    IFilterWizard wizard = (IFilterWizard)w;
                    wizard.setFilterFromCaller((IFilter)o);
                    if (e.getAttribute(FILTER_NAME) != null) {
                        wizard.setName(e.getAttribute(FILTER_NAME));
                    }
                    availableFilters.add(wizard);
                }
            }
            catch (CoreException e1) {
                LOGGER.log(Level.SEVERE, "Error in creating an Object referenced in an extension.");
                throw new RuntimeException();
            }
            LOGGER.log(Level.INFO, o.toString());
            ++n2;
        }
        return availableFilters;
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = null;
        if (this.selectedFilterWizard != null) {
            this.selectedFilterWizard.setSourceFromCaller(this.selectedSource, this);
            this.selectedFilterWizard.addPages();
            nextPage = this.selectedFilterWizard.getStartingPage();
        }
        return nextPage;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionStatus = this.statusOK;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.selectedFilterWizard = null;
        if (selection == null) {
            this.selectionStatus = new Status(4, "", 0, "Must select a Filter to proceed.", null);
        } else {
            this.selectedFilterWizard = (IFilterWizard)selection.getFirstElement();
            LOGGER.log(Level.INFO, this.selectedFilterWizard.getWindowTitle());
        }
        this.updatePageStatus();
        this.getContainer().updateButtons();
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        return pageStatus;
    }

    public void setFilter(IFilter filter) {
        LOGGER.log(Level.INFO, "Filter of FilterWizard set");
        FilterWizard wizard = (FilterWizard)this.getWizard();
        wizard.setFilter(filter);
    }
}

