/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.properties.sections;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.visualization.AbstractInput;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationInput;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.Activator;
import org.palladiosimulator.edp2.visualization.editors.AbstractEditor;
import org.palladiosimulator.edp2.visualization.properties.sections.EDP2PropertiesTable;
import org.palladiosimulator.edp2.visualization.properties.sections.InputElementList;

public class DisplayPropertySection
extends AbstractPropertySection
implements ISelectionChangedListener {
    private AbstractEditor<AbstractVisualizationSingleDatastreamInput> editor;
    private ListViewer listViewer;
    private Composite composite;
    private EDP2PropertiesTable specificPropertiesTable;
    private EDP2PropertiesTable commonPropertiesTable;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.composite.setBackground(parent.getDisplay().getSystemColor(22));
        this.composite.setSize(800, 275);
        this.createLayout(this.composite);
        Group groupCommon = new Group(this.composite, 0);
        groupCommon.setText("Common Options");
        groupCommon.setLayout((Layout)new GridLayout(1, false));
        Group groupSpecific = new Group(this.composite, 0);
        groupSpecific.setText("Input-specific Options");
        groupSpecific.setLayout((Layout)new GridLayout(2, false));
        this.listViewer = new InputElementList((Composite)groupSpecific, 0x1000000, null).getListViewer();
        this.createCommonPropertiesTable((Composite)groupCommon);
        this.createSpecificPropertiesTable((Composite)groupSpecific);
    }

    private void createCommonPropertiesTable(Composite parent) {
        this.commonPropertiesTable = new EDP2PropertiesTable(parent);
    }

    private void createSpecificPropertiesTable(Composite parent) {
        this.specificPropertiesTable = new EDP2PropertiesTable(parent);
    }

    private AbstractInput getInput() {
        AbstractInput result = null;
        if (this.editorExists()) {
            result = (AbstractInput)this.editor.getEditorInput();
        }
        return result;
    }

    public void refresh() {
        if (this.editorExists() && this.listViewer.getInput() == null) {
            this.commonPropertiesTable.setLastSelection((IPropertyConfigurable)((AbstractVisualizationInput)this.getInput()).getConfiguration());
            this.listViewer.setInput((Object)this.getInput());
            this.listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.listViewer.refresh();
        if (this.getInput() != null) {
            this.commonPropertiesTable.refreshTable();
        }
        this.composite.layout();
    }

    private void createLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        AbstractVisualizationSingleDatastreamInput lastSelectedInput = (AbstractVisualizationSingleDatastreamInput)selection.getFirstElement();
        if (lastSelectedInput != null) {
            this.specificPropertiesTable.setLastSelection((IPropertyConfigurable)lastSelectedInput.getConfiguration());
        }
        this.refresh();
    }

    private boolean editorExists() {
        IEditorPart activeEditor;
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        this.editor = null;
        if (window != null && window.getActivePage() != null && (activeEditor = window.getActivePage().getActiveEditor()) != null) {
            AbstractEditor activeAbstractEditor;
            this.editor = activeAbstractEditor = (AbstractEditor)activeEditor;
        }
        return this.editor != null;
    }
}

