/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationInput;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.IVisualisationInput;
import org.palladiosimulator.edp2.visualization.IVisualisationInputListener;
import org.palladiosimulator.edp2.visualization.IVisualization;
import org.palladiosimulator.edp2.visualization.datasource.DatasourceDropTargetAdapter;

public abstract class AbstractEditor<T extends AbstractVisualizationSingleDatastreamInput>
extends EditorPart
implements IVisualization<T>,
IVisualisationInputListener {
    public static final String EDITOR_ID = "org.palladiosimulator.edp2.visualization.editors.AbstractEditor";
    protected AbstractVisualizationInput<T> input;
    protected TabbedPropertySheetPage propertySheetPage;
    protected Composite parent;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    protected void setInput(IEditorInput input) {
        this.input = (AbstractVisualizationInput)input;
        super.setInput(input);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void saveState(IMemento memento) {
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void restoreState(IMemento memento) {
    }

    protected ISelectionProvider createSelectionProvider() {
        return new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return AbstractEditor.this.input;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    private IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null || this.propertySheetPage.getControl().isDisposed()) {
            this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, false);
        }
        return this.propertySheetPage;
    }

    public String getContributorId() {
        return EDITOR_ID;
    }

    public IEditorInput getEditorInput() {
        return this.getVisualisationInput();
    }

    protected void addDropSupport(Control control) {
        int operations = 5;
        DropTarget target = new DropTarget(control, 5);
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        target.setTransfer(transferTypes);
        target.addDropListener(new DatasourceDropTargetAdapter<T>(this.getVisualisationInput()));
    }

    @Override
    public IVisualisationInput<T> getVisualisationInput() {
        return this.input;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.setPartName(this.getEditorName());
        this.setTitleToolTip(this.getEditorName());
        this.getSite().setSelectionProvider(this.createSelectionProvider());
        this.getVisualisationInput().addObserver(this);
        this.setFocus();
    }

    protected abstract String getEditorName();

    @Override
    public void visualisationInputChanged(boolean needsDatasetReload) {
        if (needsDatasetReload) {
            this.getVisualisationInput().reloadData();
        }
        this.updateEditorContents();
    }

    public abstract void updateEditorContents();
}

