/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2;

import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.framework.BundleContext;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.RepositoryPackage;

public class EDP2Plugin
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(EDP2Plugin.class.getCanonicalName());
    public static final String PLUGIN_ID = "org.palladiosimulator.edp2";
    public static EDP2Plugin INSTANCE;
    private static final String METADATA_LOCATION_REPOSITORIES = "platform:/meta/org.palladiosimulator.edp2/repositories.edp2";
    ResourceSet rs = new ResourceSetImpl();
    Resource resource = null;

    public EDP2Plugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeResource();
        this.initializeRepositories();
    }

    public void stop(BundleContext context) throws Exception {
        this.saveRepositories();
        super.stop(context);
    }

    private void initializeRepositories() {
        try {
            Repositories repositories = (Repositories)this.resource.getContents().get(0);
            this.getRepositories().getAvailableRepositories().addAll(repositories.getAvailableRepositories());
            for (Repository repo : this.getRepositories().getAvailableRepositories()) {
                if (!repo.canOpen()) continue;
                try {
                    repo.open();
                }
                catch (DataNotAccessibleException e) {
                    LOGGER.log(Level.WARNING, "Could not open repository after reloading. Repository is " + repo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning("No preexisting EDP2 dataset configuration file. Resetting configuration...");
            this.getRepositories().getAvailableRepositories().size();
        }
    }

    private void saveRepositories() {
        this.resource.getContents().clear();
        this.resource.getContents().add((Object)this.getRepositories());
        try {
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            LOGGER.warning("Saving dataset configuration failed.");
        }
    }

    private void initializeResource() {
        this.rs.getPackageRegistry().put((Object)"http://palladiosimulator.org/EDP2/Repository/1.0", (Object)RepositoryPackage.eINSTANCE);
        URI uri = URI.createURI((String)METADATA_LOCATION_REPOSITORIES, (boolean)true);
        try {
            this.resource = this.rs.getResource(uri, true);
        }
        catch (Exception e) {
            this.resource = this.rs.createResource(uri);
        }
    }

    public Repositories getRepositories() {
        return RepositoryManager.getCentralRepository();
    }
}

