/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.models.ExperimentData;

import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactoryGen;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;

public interface ExperimentDataFactory
extends ExperimentDataFactoryGen {
    default public MeasuringType createMeasuringType(MeasuringPoint measuringPoint, MetricDescription metricDescription) {
        MeasuringType measure = this.createMeasuringType();
        measure.setMeasuringPoint(measuringPoint);
        measure.setMetric(metricDescription);
        return measure;
    }

    default public ExperimentSetting createExperimentSetting(ExperimentGroup experimentGroup, String description) {
        ExperimentSetting es = this.createExperimentSetting();
        experimentGroup.getExperimentSettings().add((Object)es);
        es.setDescription(description);
        return es;
    }

    default public ExperimentGroup createExperimentGroup(String purpose) {
        ExperimentGroup eg = this.createExperimentGroup();
        eg.setPurpose(purpose);
        return eg;
    }

    default public Measurement createMeasurement(MeasuringType forMeasuringType) {
        Measurement mms = this.createMeasurement();
        mms.setMeasuringType(forMeasuringType);
        return mms;
    }

    default public ExperimentRun createExperimentRun(ExperimentSetting forExperimentSetting) {
        ExperimentRun er = this.createExperimentRun();
        forExperimentSetting.getExperimentRuns().add((Object)er);
        return er;
    }

    default public RawMeasurements createRawMeasurements(MeasurementRange forMeasurementsRange) {
        RawMeasurements rm = this.createRawMeasurements();
        forMeasurementsRange.setRawMeasurements(rm);
        return rm;
    }

    default public MeasurementRange createMeasurementRange(Measurement forMeasurement) {
        MeasurementRange mr = this.createMeasurementRange();
        mr.setMeasurement(forMeasurement);
        return mr;
    }

    default public IdentifierBasedMeasurements createIdentifierBasedMeasurements(RawMeasurements forRawMeasurements, String valuesUuid) {
        IdentifierBasedMeasurements ibm = this.createIdentifierBasedMeasurements();
        ibm.setValuesUuid(valuesUuid);
        forRawMeasurements.getDataSeries().add((Object)ibm);
        return ibm;
    }

    default public LongBinaryMeasurements createLongBinaryMeasurements(RawMeasurements forRawMeasurements, String valuesUuid, Unit defaultUnit) {
        LongBinaryMeasurements lbm = this.createLongBinaryMeasurements();
        lbm.setValuesUuid(valuesUuid);
        lbm.setStorageUnit(defaultUnit);
        forRawMeasurements.getDataSeries().add((Object)lbm);
        return lbm;
    }

    default public DoubleBinaryMeasurements createDoubleBinaryMeasurements(RawMeasurements forRawMeasurements, String valuesUuid, Unit defaultUnit) {
        DoubleBinaryMeasurements dbm = this.createDoubleBinaryMeasurements();
        dbm.setValuesUuid(valuesUuid);
        dbm.setStorageUnit(defaultUnit);
        forRawMeasurements.getDataSeries().add(dbm);
        return dbm;
    }

    default public JSXmlMeasurements createJSXmlMeasurements(RawMeasurements forRawMeasurements, String valuesUuid) {
        JSXmlMeasurements jsxm = this.createJSXmlMeasurements();
        jsxm.setValuesUuid(valuesUuid);
        forRawMeasurements.getDataSeries().add((Object)jsxm);
        return jsxm;
    }
}

