/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.models.ExperimentData.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.MeasureFormat;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.emf.ecore.EDataType;
import org.palladiosimulator.edp2.models.ExperimentData.impl.ExperimentDataFactoryImplGen;

public class ExperimentDataFactoryImpl
extends ExperimentDataFactoryImplGen {
    private static final Logger LOGGER = Logger.getLogger(ExperimentDataFactoryImpl.class.getCanonicalName());

    @Override
    public Measure<?, ?> createEJSMeasureFromString(EDataType eDataType, String initialValue) {
        try {
            return (Measure)MeasureFormat.getInstance((NumberFormat)NumberFormat.getInstance(Locale.ENGLISH), (UnitFormat)UnitFormat.getInstance()).parseObject(initialValue);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Could not restore Measure object. Object: " + initialValue + "Error: " + e.getMessage());
            return null;
        }
    }

    @Override
    public String convertEJSMeasureToString(EDataType eDataType, Object instanceValue) {
        String result = "";
        if (instanceValue != null) {
            MeasureFormat formatter = MeasureFormat.getInstance((NumberFormat)NumberFormat.getInstance(Locale.ENGLISH), (UnitFormat)UnitFormat.getInstance());
            result = formatter.format(instanceValue);
        }
        return result;
    }

    private Measure readEJSMeasureObject(String initialValue) {
        if (initialValue == null || initialValue.isEmpty()) {
            return null;
        }
        String[] items = initialValue.split(" ");
        Double value = 0.0;
        Unit unit = null;
        try {
            value = Double.valueOf(items[0]);
            if (items.length < 2) {
                return Measure.valueOf((double)value, (Unit)Dimensionless.UNIT);
            }
            UnitFormat formatter = UnitFormat.getInstance();
            unit = formatter.parseObject(items[1], new ParsePosition(0));
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.SEVERE, "Could not restore Measure object. It has to start with a number.Object: " + initialValue + "Error: " + nfe.getMessage());
            return null;
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.SEVERE, "Could not restore Measure object. It has wrong dimension. It receives no dimension.Object: " + initialValue + "Error: " + iae.getMessage());
        }
        if (unit == null) {
            unit = Dimensionless.UNIT;
        }
        return Measure.valueOf((double)value, (Unit)unit);
    }

    @Override
    public Measure createEJSDurationMeasureFromString(EDataType eDataType, String initialValue) {
        return (Measure)this.readObject(initialValue);
    }

    @Override
    public String convertEJSDurationMeasureToString(EDataType eDataType, Object instanceValue) {
        return this.writeObject(instanceValue);
    }

    private String writeObject(Object o) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bas);
            oos.writeObject(o);
            oos.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not serialize object to string. Data corruption is likely. Object: " + o + "Error: " + e.getMessage());
        }
        return Base64.encodeBase64String((byte[])bas.toByteArray());
    }

    private Object readObject(String input) {
        Object o = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.decodeBase64((String)input)));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not deserialize object from string. Data corruption is likely. Error: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not deserialize object from string. No class for object could be found. Data corruption is likely. Error: " + e.getMessage());
        }
        return o;
    }
}

