/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.windowaggregators;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowAggregator;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.IRecorder;

public class SlidingWindowUtilizationAggregator
extends SlidingWindowAggregator {
    protected static final Amount<Duration> ZERO_DURATION = Amount.valueOf((long)0L, (Unit)SI.SECOND);
    private static final Map<MetricDescription, NumericalBaseMetricDescription> EXPECTED_WINDOW_METRICS_MAP = new HashMap<MetricDescription, NumericalBaseMetricDescription>();
    private static final Collection<MetricDescription> EXPECTED_WINDOW_DATA_METRICS = EXPECTED_WINDOW_METRICS_MAP.keySet();
    private final MetricDescription windowDataMetric;
    private final NumericalBaseMetricDescription stateOfResourceMetric;

    static {
        EXPECTED_WINDOW_METRICS_MAP.put((MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, (NumericalBaseMetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC);
        EXPECTED_WINDOW_METRICS_MAP.put((MetricDescription)MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, (NumericalBaseMetricDescription)MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE);
    }

    public SlidingWindowUtilizationAggregator(MetricDescription windowDataMetric, IRecorder recorderToWriteInto) {
        super(recorderToWriteInto);
        Objects.requireNonNull(windowDataMetric, "Given metric must not be null.");
        Optional<MetricDescription> foundMetric = EXPECTED_WINDOW_DATA_METRICS.stream().filter(m -> MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)m, (MetricDescription)windowDataMetric)).findAny();
        this.windowDataMetric = foundMetric.orElseThrow(() -> new IllegalArgumentException("This aggregator cannot deal with window data of the given metric."));
        this.stateOfResourceMetric = EXPECTED_WINDOW_METRICS_MAP.get(this.windowDataMetric);
    }

    @Override
    protected MeasuringValue processWindowData(Iterable<MeasuringValue> windowData, Measure<Double, Duration> windowLeftBound, Measure<Double, Duration> windowLength) {
        Amount<Duration> windowLeftBoundAmount = Amount.valueOf((double)((Double)windowLeftBound.getValue()), (Unit)windowLeftBound.getUnit());
        Amount windowLengthAmount = Amount.valueOf((double)((Double)windowLength.getValue()), (Unit)windowLength.getUnit());
        Amount<Duration> windowRightBoundAmount = windowLengthAmount.plus((Amount)windowLeftBoundAmount);
        MeasuringValue result = null;
        Amount busyTime = ZERO_DURATION;
        Iterator<MeasuringValue> iterator = windowData.iterator();
        if (iterator.hasNext()) {
            MeasuringValue nextMeasurement = null;
            Amount<Duration> nextPointInTimeAmount = null;
            MeasuringValue currentMeasurement = iterator.next();
            double currentStateValue = this.obtainStateValueFromMeasurement(currentMeasurement);
            Amount<Duration> currentPointInTimeAmount = SlidingWindowUtilizationAggregator.obtainPointInTimeAmountFromMeasurement(currentMeasurement);
            boolean endLoop = false;
            do {
                Amount<Duration> amount = currentPointInTimeAmount = currentPointInTimeAmount.isLessThan((Amount)windowLeftBoundAmount) ? windowLeftBoundAmount : currentPointInTimeAmount;
                if (iterator.hasNext()) {
                    nextMeasurement = iterator.next();
                    nextPointInTimeAmount = SlidingWindowUtilizationAggregator.obtainPointInTimeAmountFromMeasurement(nextMeasurement);
                } else {
                    nextPointInTimeAmount = windowRightBoundAmount;
                    endLoop = true;
                }
                busyTime = busyTime.plus(nextPointInTimeAmount.minus(currentPointInTimeAmount).times(Math.min(currentStateValue, 1.0)));
                if (endLoop) continue;
                currentMeasurement = nextMeasurement;
                currentStateValue = this.obtainStateValueFromMeasurement(nextMeasurement);
                currentPointInTimeAmount = nextPointInTimeAmount;
            } while (!endLoop);
        }
        result = SlidingWindowUtilizationAggregator.createUtilizationTupleMeasurement(busyTime, (Amount<Duration>)windowLengthAmount, windowRightBoundAmount);
        return result;
    }

    private static MeasuringValue createUtilizationTupleMeasurement(Amount<Duration> busyTime, Amount<Duration> windowLength, Amount<Duration> pointInTime) {
        assert (windowLength.isGreaterThan(ZERO_DURATION));
        Amount utilization = busyTime.divide(windowLength);
        Measure resultUtilizationMeasure = Measure.valueOf((double)utilization.doubleValue(Unit.ONE), (Unit)Unit.ONE);
        Measure resultPointInTimeMeasure = Measure.valueOf((double)pointInTime.doubleValue(pointInTime.getUnit()), (Unit)pointInTime.getUnit());
        return new TupleMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, new Measure[]{resultPointInTimeMeasure, resultUtilizationMeasure});
    }

    protected static Amount<Duration> obtainPointInTimeAmountFromMeasurement(MeasuringValue measurement) {
        Measure measure = measurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        return Amount.valueOf((double)measure.doubleValue(measure.getUnit()), (Unit)measure.getUnit());
    }

    protected Amount<Dimensionless> obtainStateAmountFromMeasurement(MeasuringValue measurement) {
        assert (measurement != null && measurement.isCompatibleWith(this.windowDataMetric));
        Measure measure = measurement.getMeasureForMetric((MetricDescription)this.stateOfResourceMetric);
        return Amount.valueOf((double)measure.doubleValue(measure.getUnit()), (Unit)measure.getUnit());
    }

    private double obtainStateValueFromMeasurement(MeasuringValue measurement) {
        assert (measurement != null && measurement.isCompatibleWith(this.windowDataMetric));
        Measure measure = measurement.getMeasureForMetric((MetricDescription)this.stateOfResourceMetric);
        return measure.doubleValue(Dimensionless.UNIT);
    }

    @Override
    public MetricDescription getExpectedWindowDataMetric() {
        return this.windowDataMetric;
    }

    public static Collection<MetricDescription> getAllowedWindowDataMetrics() {
        return Collections.unmodifiableCollection(EXPECTED_WINDOW_DATA_METRICS);
    }
}

