/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.ui.workflow;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.AbstractConfigurationTab;

public class ExperimentAutomationConfigurationTab
extends AbstractConfigurationTab {
    public static final String SELECT_EXPERIMENTS_FILE = "Select Experiments File";
    public static final String EXPERIMENTS_FILE = "Experiments File";
    public static final String DEFAULT_EXPERIMENTS = "";
    public static final String EXPERIMENT_AUTOMATION = "Experiment Automation";
    public static final String[] EXPERIMENTS_EXTENSION = new String[]{"*.experiments"};
    private Text experimentsText;

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.experimentsText.setText(configuration.getAttribute(EXPERIMENT_AUTOMATION, DEFAULT_EXPERIMENTS));
        }
        catch (CoreException e) {
            this.experimentsText.setText(DEFAULT_EXPERIMENTS);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute(EXPERIMENT_AUTOMATION, this.experimentsText.getText());
    }

    protected void createFurtherSections(Composite parent) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExperimentAutomationConfigurationTab.this.setDirty(true);
                ExperimentAutomationConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.experimentsText = new Text(parent, 2052);
        TabHelper.createFileInputSection((Composite)parent, (ModifyListener)this.modifyListener, (String)EXPERIMENTS_FILE, (String[])EXPERIMENTS_EXTENSION, (Text)this.experimentsText, (String)SELECT_EXPERIMENTS_FILE, (Shell)this.getShell(), (String)DEFAULT_EXPERIMENTS);
    }

    public String getName() {
        return EXPERIMENT_AUTOMATION;
    }
}

