/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.variation.valueprovider;

import org.palladiosimulator.experimentautomation.application.variation.valueprovider.AbstractNestedIntervalsValueProviderStrategy;
import org.palladiosimulator.experimentautomation.experiments.NestedIntervalsDoubleValueProvider;

public class NestedIntervalsDoubleValueProviderStrategy
extends AbstractNestedIntervalsValueProviderStrategy<Double> {
    private Double min;
    private Double middle;
    private Double max;

    public NestedIntervalsDoubleValueProviderStrategy(NestedIntervalsDoubleValueProvider specification) {
        this.min = specification.getMinValue();
        this.max = specification.getMaxValue();
        this.middle = this.min;
    }

    @Override
    public Double valueAtPosition(int position) {
        if (position != 0) {
            return -1.0;
        }
        return this.middle;
    }

    @Override
    public void setMin(Double min) {
        if (min < this.min) {
            throw new IllegalArgumentException("New interval has to be nested in original interval");
        }
        if (this.min == this.middle && this.middle != this.max) {
            this.middle = this.max;
            this.min = min;
        } else {
            this.min = min;
            this.calculateMiddle();
        }
        if (this.min == this.max) {
            this.converged = true;
        } else if (this.min == this.middle) {
            this.middle = this.middle + 1.0;
        }
    }

    @Override
    public void setMax(Double max) {
        if (max > this.max) {
            throw new IllegalArgumentException("New interval has to be nested in original interval");
        }
        if (this.min > max) {
            this.min = max;
        }
        this.max = max;
        this.calculateMiddle();
        if (this.min == this.max) {
            this.converged = true;
        }
    }

    private void calculateMiddle() {
        this.middle = (this.min + this.max) / 2.0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Capacity Interval: [");
        stringBuilder.append(String.valueOf(this.min));
        stringBuilder.append(", ");
        stringBuilder.append(String.valueOf(this.max));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

