/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.commons.emfutils.EMFCopyHelper;

public class CopyPartitionJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(CopyPartitionJob.class);
    private final String sourcePartition;
    private final String targetPartition;

    public CopyPartitionJob(String sourcePartition, String targetPartition) {
        super(false);
        this.sourcePartition = sourcePartition;
        this.targetPartition = targetPartition;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        LOGGER.info((Object)("Copy resource set from " + this.sourcePartition + " to " + this.targetPartition));
        ((MDSDBlackboard)this.getBlackboard()).removePartition(this.targetPartition);
        PCMResourceSetPartition newPartition = new PCMResourceSetPartition();
        ResourceSetPartition orginalPCMModelPartition = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition(this.sourcePartition);
        List modelCopy = EMFCopyHelper.deepCopyToEObjectList((ResourceSet)orginalPCMModelPartition.getResourceSet());
        int i = 0;
        while (i < modelCopy.size()) {
            Resource resource = newPartition.getResourceSet().createResource(URI.createFileURI((String)("/temp" + i)));
            resource.getContents().add((Object)((EObject)modelCopy.get(i)));
            ++i;
        }
        ((MDSDBlackboard)this.getBlackboard()).addPartition(this.targetPartition, (Object)newPartition);
    }

    public String getName() {
        return "Clone Partition Contents";
    }
}

