/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.RepositoryFactory;
import org.palladiosimulator.edp2.repository.local.LocalDirectoryRepositoryHelper;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractsimulationPackage;
import org.palladiosimulator.experimentautomation.abstractsimulation.EDP2Datasource;
import org.palladiosimulator.experimentautomation.abstractsimulation.FileDatasource;

public class EDP2DatasourceFactory {
    public static Repository createOrOpenDatasource(EDP2Datasource datasource) {
        Object repository;
        if (datasource.getId() != null) {
            return RepositoryManager.getRepositoryFromUUID((String)datasource.getId());
        }
        if (AbstractsimulationPackage.eINSTANCE.getMemoryDatasource().isInstance((Object)datasource)) {
            repository = RepositoryFactory.eINSTANCE.createLocalMemoryRepository();
        } else if (AbstractsimulationPackage.eINSTANCE.getFileDatasource().isInstance((Object)datasource)) {
            FileDatasource fileDatasource = (FileDatasource)datasource;
            File file = new File(fileDatasource.getLocation());
            String repositoryID = URI.createFileURI((String)file.getAbsolutePath()).toString();
            Repository ldRepository = RepositoryManager.getRepositoryFromUUID((String)repositoryID);
            repository = ldRepository == null ? LocalDirectoryRepositoryHelper.initializeLocalDirectoryRepository((File)file) : ldRepository;
        } else {
            throw new RuntimeException("Could not determine datasource type. This should not have happened.");
        }
        RepositoryManager.addRepository((Repositories)RepositoryManager.getCentralRepository(), (Repository)repository);
        datasource.setId(repository.getId());
        return repository;
    }
}

