/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.variation;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.experimentautomation.application.variation.IVariationStrategy;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

public class LoadBalancingVariation
implements IVariationStrategy<Long> {
    private BasicComponent loadBalancer;
    private static final Logger LOGGER = Logger.getLogger(LoadBalancingVariation.class);

    @Override
    public void setVariedObject(EObject o) {
        if (!BasicComponent.class.isInstance(o)) {
            throw new RuntimeException("Expected a BasicComponent, but encountered a " + o.getClass().getName());
        }
        this.loadBalancer = (BasicComponent)o;
    }

    @Override
    public String vary(Long value) {
        String semaphoreResult = this.adjustSemaphore(value);
        String branchProbresult = this.adjustBranchProbabilities(value);
        return String.valueOf(semaphoreResult) + "\n" + branchProbresult;
    }

    private String adjustSemaphore(long value) {
        PassiveResource semaphore = this.getFirstPassiveResource(this.loadBalancer);
        semaphore.getCapacity_PassiveResource().setSpecification(Double.toString(value));
        return "Parameter value of " + semaphore.eClass().getName() + "'" + semaphore.getEntityName() + "' = " + value + ": ";
    }

    private PassiveResource getFirstPassiveResource(BasicComponent loadBalancer) {
        return (PassiveResource)loadBalancer.getPassiveResource_BasicComponent().get(0);
    }

    private String adjustBranchProbabilities(long value) {
        double branchProbability = 1.0 / (double)value;
        EList seffs = this.loadBalancer.getServiceEffectSpecifications__BasicComponent();
        for (ServiceEffectSpecification serviceEffectSpecification : seffs) {
            BranchAction branch = this.getBranchAction(serviceEffectSpecification);
            LOGGER.debug((Object)("Number of branches: " + branch.getBranches_Branch().size() + ", new BranchProbability: " + branchProbability));
            int i = 0;
            while (i < branch.getBranches_Branch().size()) {
                AbstractBranchTransition t = (AbstractBranchTransition)branch.getBranches_Branch().get(i);
                if (!(t instanceof ProbabilisticBranchTransition)) {
                    throw new RuntimeException("ProbabilisticBranchTransition expected. Found " + t.getClass().getName());
                }
                ProbabilisticBranchTransition pTrans = (ProbabilisticBranchTransition)t;
                if ((long)i < value) {
                    pTrans.setBranchProbability(branchProbability);
                } else {
                    pTrans.setBranchProbability(0.0);
                }
                ++i;
            }
        }
        return "Branch probabilities of BranchActions within SEFFs" + seffs.toString() + " adjusted.";
    }

    private BranchAction getBranchAction(ServiceEffectSpecification seff) {
        ResourceDemandingSEFF rdSeff = (ResourceDemandingSEFF)seff;
        EList setps = rdSeff.getSteps_Behaviour();
        for (AbstractAction abstractAction : setps) {
            if (!(abstractAction instanceof BranchAction)) continue;
            return (BranchAction)abstractAction;
        }
        return null;
    }
}

