/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.abstractsimulation.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractsimulationFactory;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractsimulationPackage;
import org.palladiosimulator.experimentautomation.abstractsimulation.ExportOption;
import org.palladiosimulator.experimentautomation.abstractsimulation.FileDatasource;
import org.palladiosimulator.experimentautomation.abstractsimulation.MeasurementCountStopCondition;
import org.palladiosimulator.experimentautomation.abstractsimulation.MemoryDatasource;
import org.palladiosimulator.experimentautomation.abstractsimulation.RandomNumberGeneratorSeed;
import org.palladiosimulator.experimentautomation.abstractsimulation.SimTimeStopCondition;
import org.palladiosimulator.experimentautomation.abstractsimulation.impl.FileDatasourceImpl;
import org.palladiosimulator.experimentautomation.abstractsimulation.impl.MeasurementCountStopConditionImpl;
import org.palladiosimulator.experimentautomation.abstractsimulation.impl.MemoryDatasourceImpl;
import org.palladiosimulator.experimentautomation.abstractsimulation.impl.RandomNumberGeneratorSeedImpl;
import org.palladiosimulator.experimentautomation.abstractsimulation.impl.SimTimeStopConditionImpl;

public class AbstractsimulationFactoryImpl
extends EFactoryImpl
implements AbstractsimulationFactory {
    public static final String copyright = "Palladiosimulator.org 2008-2017";

    public static AbstractsimulationFactory init() {
        try {
            AbstractsimulationFactory theAbstractsimulationFactory = (AbstractsimulationFactory)EPackage.Registry.INSTANCE.getEFactory("http://palladiosimulator.org/ExperimentAutomation/AbstractSimulation/1.0");
            if (theAbstractsimulationFactory != null) {
                return theAbstractsimulationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new AbstractsimulationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createRandomNumberGeneratorSeed();
            }
            case 3: {
                return this.createMemoryDatasource();
            }
            case 4: {
                return this.createFileDatasource();
            }
            case 5: {
                return this.createMeasurementCountStopCondition();
            }
            case 6: {
                return this.createSimTimeStopCondition();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createExportOptionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertExportOptionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public RandomNumberGeneratorSeed createRandomNumberGeneratorSeed() {
        RandomNumberGeneratorSeedImpl randomNumberGeneratorSeed = new RandomNumberGeneratorSeedImpl();
        return randomNumberGeneratorSeed;
    }

    @Override
    public MemoryDatasource createMemoryDatasource() {
        MemoryDatasourceImpl memoryDatasource = new MemoryDatasourceImpl();
        return memoryDatasource;
    }

    @Override
    public FileDatasource createFileDatasource() {
        FileDatasourceImpl fileDatasource = new FileDatasourceImpl();
        return fileDatasource;
    }

    @Override
    public MeasurementCountStopCondition createMeasurementCountStopCondition() {
        MeasurementCountStopConditionImpl measurementCountStopCondition = new MeasurementCountStopConditionImpl();
        return measurementCountStopCondition;
    }

    @Override
    public SimTimeStopCondition createSimTimeStopCondition() {
        SimTimeStopConditionImpl simTimeStopCondition = new SimTimeStopConditionImpl();
        return simTimeStopCondition;
    }

    public ExportOption createExportOptionFromString(EDataType eDataType, String initialValue) {
        ExportOption result = ExportOption.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertExportOptionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public AbstractsimulationPackage getAbstractsimulationPackage() {
        return (AbstractsimulationPackage)this.getEPackage();
    }

    @Deprecated
    public static AbstractsimulationPackage getPackage() {
        return AbstractsimulationPackage.eINSTANCE;
    }
}

