/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.Collection;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class AcquireActionCreator
extends GeneralAction {
    private PassiveResource passiveResource;
    private Double timeoutValue;
    private Boolean isTimeout;

    protected AcquireActionCreator(SeffCreator seff) {
        this.seff = seff;
    }

    @Override
    public AcquireActionCreator withName(String name) {
        return (AcquireActionCreator)super.withName(name);
    }

    public AcquireActionCreator withPassiveResource(PassiveResource passiveResource) {
        IllegalArgumentException.throwIfNull(passiveResource, "passiveResource must not be null");
        this.passiveResource = passiveResource;
        return this;
    }

    public AcquireActionCreator withTimeoutValue(double timeoutValue) {
        this.timeoutValue = timeoutValue;
        return this;
    }

    public AcquireActionCreator isTimeout(Boolean isTimeout) {
        IllegalArgumentException.throwIfNull(isTimeout, "isTimeout must not be null");
        this.isTimeout = isTimeout;
        return this;
    }

    @Override
    public AcquireActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (AcquireActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public AcquireActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (AcquireActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public AcquireActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (AcquireActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected AcquireAction build() {
        AcquireAction action = SeffFactory.eINSTANCE.createAcquireAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.passiveResource != null) {
            action.setPassiveresource_AcquireAction(this.passiveResource);
        }
        if (this.timeoutValue != null) {
            action.setTimeoutValue(this.timeoutValue.doubleValue());
        }
        if (this.isTimeout != null) {
            action.setTimeout(this.isTimeout.booleanValue());
        }
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

