/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.event;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.event.SinkRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.SinkDelegationConnector;
import org.palladiosimulator.pcm.repository.SinkRole;

public class SinkDelegationConnectorCreator
extends AbstractConnectorCreator {
    private SinkRole outerRole;
    private SinkRole innerRole;
    private AssemblyContext assemblyContext;

    public SinkDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public SinkDelegationConnectorCreator withOuterSinkRole(SinkRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.outerRole = role;
        return this;
    }

    public SinkDelegationConnectorCreator withOuterSinkRole(String name) throws NoSuchElementException {
        SinkRole role = this.system.getSystemSinkRoleByName(name);
        return this.withOuterSinkRole(role);
    }

    public SinkRoleSelector<SinkDelegationConnectorCreator> withAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new SinkRoleSelector<SinkDelegationConnectorCreator>((context1, role) -> {
            this.assemblyContext = context1;
            this.innerRole = role;
            return this;
        }, context);
    }

    public SinkRoleSelector<SinkDelegationConnectorCreator> withAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withAssemblyContext(context);
    }

    public SinkDelegationConnector build() {
        SinkDelegationConnector connector = CompositionFactory.eINSTANCE.createSinkDelegationConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setAssemblyContext__SinkDelegationConnector(this.assemblyContext);
        connector.setOuterSinkRole__SinkRole(this.outerRole);
        connector.setInnerSinkRole__SinkRole(this.innerRole);
        return connector;
    }

    @Override
    public SinkDelegationConnectorCreator withName(String name) {
        return (SinkDelegationConnectorCreator)super.withName(name);
    }
}

