/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.ActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.BranchTransitionCreator;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

public class BranchActionCreator
extends ActionCreator {
    private final List<BranchTransition> transitions = new ArrayList<BranchTransition>();

    public BranchActionCreator addToBranchAction(BranchTransitionCreator branchTransition) {
        IllegalArgumentException.throwIfNull(branchTransition, "The given Branch Transition must not be null");
        this.transitions.add(branchTransition.build());
        return this;
    }

    public Branch build() {
        Branch b = UsagemodelFactory.eINSTANCE.createBranch();
        b.getBranchTransitions_Branch().addAll(this.transitions);
        if (this.name != null) {
            b.setEntityName(this.name);
        }
        if (this.successor != null) {
            b.setSuccessor(this.successor);
        }
        return b;
    }

    @Override
    public BranchActionCreator withSuccessor(ActionCreator action) {
        return (BranchActionCreator)super.withSuccessor(action);
    }

    @Override
    public BranchActionCreator withName(String name) {
        return (BranchActionCreator)super.withName(name);
    }
}

