/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffAction;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformanceFactory;

public abstract class GeneralAction
extends SeffAction {
    protected List<ParametricResourceDemand> demands = new ArrayList<ParametricResourceDemand>();
    protected List<InfrastructureCall> infrastructureCalls = new ArrayList<InfrastructureCall>();
    protected List<ResourceCall> resourceCalls = new ArrayList<ResourceCall>();

    public GeneralAction withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        IllegalArgumentException.throwIfNull(specificationStochasticExpression, "specification_stochasticExpression must not be null");
        IllegalArgumentException.throwIfNull(processingResource, "processingResource must not be null");
        ParametricResourceDemand demand = SeffPerformanceFactory.eINSTANCE.createParametricResourceDemand();
        ProcessingResourceType processingResourceType = this.repository.getProcessingResourceType(processingResource);
        demand.setRequiredResource_ParametricResourceDemand(processingResourceType);
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(specificationStochasticExpression);
        demand.setSpecification_ParametericResourceDemand(rand);
        this.demands.add(demand);
        return this;
    }

    public GeneralAction withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        IllegalArgumentException.throwIfNull(numberOfCallsStochasticExpression, "numberOfCalls_stochasticExpression must not be null");
        IllegalArgumentException.throwIfNull(signature, "signature must not be null");
        IllegalArgumentException.throwIfNull(requiredRole, "requiredRole must not be null");
        IllegalArgumentException.throwIfNull(variableUsages, "variable usages must not be null");
        if (variableUsages.length > 0) {
            VariableUsageCreator[] variableUsageCreatorArray = variableUsages;
            int n = variableUsages.length;
            int n2 = 0;
            while (n2 < n) {
                VariableUsageCreator variableUsage = variableUsageCreatorArray[n2];
                IllegalArgumentException.throwIfNull(variableUsage, "variable usages must not be null");
                ++n2;
            }
        }
        InfrastructureCall call = SeffPerformanceFactory.eINSTANCE.createInfrastructureCall();
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(numberOfCallsStochasticExpression);
        call.setNumberOfCalls__InfrastructureCall(rand);
        call.setRequiredRole__InfrastructureCall(requiredRole);
        call.setSignature__InfrastructureCall(signature);
        if (variableUsages.length > 0) {
            Arrays.asList(variableUsages).stream().map(VariableUsageCreator::build).forEach(v -> {
                boolean bl = call.getInputVariableUsages__CallAction().add(v);
            });
        }
        this.infrastructureCalls.add(call);
        return this;
    }

    public GeneralAction withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        IllegalArgumentException.throwIfNull(numberOfCallsStochasticExpression, "numberOfCalls_stochasticExpression must not be null");
        IllegalArgumentException.throwIfNull(signature, "signature must not be null");
        IllegalArgumentException.throwIfNull(requiredRole, "requiredRole must not be null");
        if (variableUsages != null && variableUsages.length > 0) {
            VariableUsageCreator[] variableUsageCreatorArray = variableUsages;
            int n = variableUsages.length;
            int n2 = 0;
            while (n2 < n) {
                VariableUsageCreator variableUsage = variableUsageCreatorArray[n2];
                IllegalArgumentException.throwIfNull(variableUsage, "variable usages must not be null");
                ++n2;
            }
        }
        ResourceCall call = SeffPerformanceFactory.eINSTANCE.createResourceCall();
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(numberOfCallsStochasticExpression);
        call.setNumberOfCalls__ResourceCall(rand);
        org.palladiosimulator.pcm.resourcetype.ResourceSignature resourceSignature = this.repository.getResourceSignature(signature);
        call.setSignature__ResourceCall(resourceSignature);
        call.setResourceRequiredRole__ResourceCall(requiredRole);
        if (variableUsages != null && variableUsages.length != 0) {
            Arrays.asList(variableUsages).stream().map(VariableUsageCreator::build).forEach(v -> {
                boolean bl = call.getInputVariableUsages__CallAction().add(v);
            });
        }
        this.resourceCalls.add(call);
        return this;
    }
}

