/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.types;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class CompositeDataTypeCreator
extends RepositoryEntity {
    private final List<CompositeDataType> parents;
    private final List<InnerDeclaration> innerDeclarations;

    public CompositeDataTypeCreator(RepositoryCreator repo) {
        this.repository = repo;
        this.parents = new ArrayList<CompositeDataType>();
        this.innerDeclarations = new ArrayList<InnerDeclaration>();
    }

    @Override
    public CompositeDataTypeCreator withName(String name) {
        return (CompositeDataTypeCreator)super.withName(name);
    }

    public CompositeDataTypeCreator withInnerDeclaration(String name, Primitive primitive) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(primitive, "primitive must not be null");
        InnerDeclaration inner = RepositoryFactory.eINSTANCE.createInnerDeclaration();
        inner.setEntityName(name);
        PrimitiveDataType p = this.repository.getPrimitiveDataType(primitive);
        inner.setDatatype_InnerDeclaration((DataType)p);
        this.innerDeclarations.add(inner);
        return this;
    }

    public CompositeDataTypeCreator withInnerDeclaration(String name, DataType dataType) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        InnerDeclaration inner = RepositoryFactory.eINSTANCE.createInnerDeclaration();
        inner.setEntityName(name);
        inner.setDatatype_InnerDeclaration(dataType);
        this.innerDeclarations.add(inner);
        return this;
    }

    public CompositeDataTypeCreator withParentCompositeDataType(CompositeDataType parent) {
        IllegalArgumentException.throwIfNull(parent, "parent must not be null");
        this.parents.add(parent);
        return this;
    }

    public CompositeDataType build() {
        CompositeDataType comp = RepositoryFactory.eINSTANCE.createCompositeDataType();
        comp.setEntityName(this.name);
        comp.getParentType_CompositeDataType().addAll(this.parents);
        comp.getInnerDeclaration_CompositeDataType().addAll(this.innerDeclarations);
        return comp;
    }
}

