/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.shared.validate.IModelValidator;
import org.palladiosimulator.generator.fluent.system.api.ISystem;
import org.palladiosimulator.generator.fluent.system.api.ISystemAddition;
import org.palladiosimulator.generator.fluent.system.structure.AssemblyContextCreator;
import org.palladiosimulator.generator.fluent.system.structure.EventChannelCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.resource.ResourceRequiredDelegationConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.qos.QoSAnnotationsCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.InfrastructureProvidedRoleCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.InfrastructureRequiredRoleCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.OperationProvidedRoleCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.OperationRequiredRoleCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.ResourceRequiredRoleCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.SinkRoleCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.SourceRoleCreator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.composition.ResourceRequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.resourcetype.ResourceInterface;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemFactory;

public class SystemCreator
extends SystemEntity
implements ISystem {
    private final IModelValidator validator;
    private final ResourceRepository resources;
    private final List<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
    private final List<Repository> repositories = new ArrayList<Repository>();
    private final List<Connector> connectors = new ArrayList<Connector>();
    private final List<OperationRequiredRole> systemOperationRequiredRoles = new ArrayList<OperationRequiredRole>();
    private final List<OperationProvidedRole> systemOperationProvidedRoles = new ArrayList<OperationProvidedRole>();
    private final List<InfrastructureRequiredRole> systemInfrastructureRequiredRoles = new ArrayList<InfrastructureRequiredRole>();
    private final List<InfrastructureProvidedRole> systemInfrastructureProvidedRoles = new ArrayList<InfrastructureProvidedRole>();
    private final List<SinkRole> systemSinkRoles = new ArrayList<SinkRole>();
    private final List<SourceRole> systemSourceRoles = new ArrayList<SourceRole>();
    private final List<ResourceRequiredRole> systemResourceRequiredRoles = new ArrayList<ResourceRequiredRole>();
    private final List<EventChannel> eventChannels = new ArrayList<EventChannel>();
    private final List<QoSAnnotations> qoSAnnotations = new ArrayList<QoSAnnotations>();
    private final List<ResourceRequiredDelegationConnector> resourceConnectors = new ArrayList<ResourceRequiredDelegationConnector>();

    public SystemCreator(ResourceRepository resources, IModelValidator validator) {
        this.resources = resources;
        this.validator = validator;
    }

    @Override
    public SystemCreator withName(String name) {
        return (SystemCreator)super.withName(name);
    }

    protected System build() {
        System system = SystemFactory.eINSTANCE.createSystem();
        if (this.name != null) {
            system.setEntityName(this.name);
        }
        system.getAssemblyContexts__ComposedStructure().addAll(this.assemblyContexts);
        system.getConnectors__ComposedStructure().addAll(this.connectors);
        system.getRequiredRoles_InterfaceRequiringEntity().addAll(this.systemOperationRequiredRoles);
        system.getProvidedRoles_InterfaceProvidingEntity().addAll(this.systemOperationProvidedRoles);
        system.getRequiredRoles_InterfaceRequiringEntity().addAll(this.systemSourceRoles);
        system.getProvidedRoles_InterfaceProvidingEntity().addAll(this.systemSinkRoles);
        system.getRequiredRoles_InterfaceRequiringEntity().addAll(this.systemInfrastructureRequiredRoles);
        system.getProvidedRoles_InterfaceProvidingEntity().addAll(this.systemInfrastructureProvidedRoles);
        system.getEventChannel__ComposedStructure().addAll(this.eventChannels);
        system.getQosAnnotations_System().addAll(this.qoSAnnotations);
        system.getResourceRequiredRoles__ResourceInterfaceRequiringEntity().addAll(this.systemResourceRequiredRoles);
        system.getResourceRequiredDelegationConnectors_ComposedStructure().addAll(this.resourceConnectors);
        return system;
    }

    @Override
    public System createSystemNow() {
        System system = this.build();
        this.validator.validate((EObject)system, this.name);
        return system;
    }

    @Override
    public ISystemAddition addToSystem(AssemblyContextCreator context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        this.assemblyContexts.add(context.build());
        return this;
    }

    @Override
    public ISystem addRepository(Repository repository) {
        IllegalArgumentException.throwIfNull(repository, "The given Repository must not be null.");
        this.repositories.add(repository);
        return this;
    }

    @Override
    public ISystemAddition addToSystem(AbstractConnectorCreator connector) {
        IllegalArgumentException.throwIfNull(connector, "The given Connector must not be null.");
        this.connectors.add(connector.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(OperationRequiredRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemOperationRequiredRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(OperationProvidedRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemOperationProvidedRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(EventChannelCreator eventChannel) {
        IllegalArgumentException.throwIfNull(eventChannel, "The given EventChannel must not be null.");
        this.eventChannels.add(eventChannel.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(SinkRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemSinkRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(SourceRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemSourceRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(InfrastructureRequiredRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemInfrastructureRequiredRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(InfrastructureProvidedRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemInfrastructureProvidedRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(QoSAnnotationsCreator annotations) {
        IllegalArgumentException.throwIfNull(annotations, "The given QoSAnnotations must not be null.");
        this.qoSAnnotations.add(annotations.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(ResourceRequiredRoleCreator role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.systemResourceRequiredRoles.add(role.build());
        return this;
    }

    @Override
    public ISystemAddition addToSystem(ResourceRequiredDelegationConnectorCreator connector) {
        IllegalArgumentException.throwIfNull(connector, "The given Connector must not be null.");
        this.resourceConnectors.add(connector.build());
        return this;
    }

    public Interface getInterfaceByName(String name) throws NoSuchElementException {
        return this.repositories.stream().flatMap(x -> x.getInterfaces__Repository().stream()).filter(i -> i.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No Interface with name '%s' was found.", name)));
    }

    public RepositoryComponent getRepositoryComponentByName(String name) throws NoSuchElementException {
        return this.repositories.stream().flatMap(x -> x.getComponents__Repository().stream()).filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No RepositoryComponent with name '%s' found.", name)));
    }

    public AssemblyContext getAssemblyContextByName(String name) throws NoSuchElementException {
        return this.assemblyContexts.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No AssemblyContext with name '%s' found", name)));
    }

    public ResourceRequiredRole getResourceRequiredRoleByName(String name) throws NoSuchElementException {
        return this.assemblyContexts.stream().flatMap(x -> x.getEncapsulatedComponent__AssemblyContext().getResourceRequiredRoles__ResourceInterfaceRequiringEntity().stream()).filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No ResourceRequiredRole with name '%s' found", name)));
    }

    public OperationRequiredRole getSystemOperationRequiredRoleByName(String name) throws NoSuchElementException {
        return this.systemOperationRequiredRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No OperationRequiredRole with name '%s' found.", name)));
    }

    public OperationProvidedRole getSystemOperationProvidedRoleByName(String name) {
        return this.systemOperationProvidedRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No OperationProvidedRole with name '%s' found.", name)));
    }

    public SinkRole getSystemSinkRoleByName(String name) throws NoSuchElementException {
        return this.systemSinkRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No SinkRole with name '%s' found", name)));
    }

    public InfrastructureRequiredRole getSystemInfrastructureRequiredRoleByName(String name) throws NoSuchElementException {
        return this.systemInfrastructureRequiredRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No InfrastructureRequiredRole with name '%s' found.", name)));
    }

    public InfrastructureProvidedRole getSystemInfrastructureProvidedRoleByName(String name) throws NoSuchElementException {
        return this.systemInfrastructureProvidedRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No InfrastructureProvidedRole with name '%s' found.", name)));
    }

    public SourceRole getSystemSourceRoleByName(String name) throws NoSuchElementException {
        return this.systemSourceRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No SourceRole with name '%s' found.", name)));
    }

    public ResourceRequiredRole getSystemResourceRequiredRoleByName(String name) throws NoSuchElementException {
        return this.systemResourceRequiredRoles.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No ResourceRequiredRole with name '%s' found.", name)));
    }

    public EventChannel getEventChannelByName(String name) throws NoSuchElementException {
        return this.eventChannels.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No EventChannel with name '%s' found.", name)));
    }

    public ResourceInterface getResourceInterface(org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface resource) {
        IllegalArgumentException.throwIfNull(resource, "The given resource must not be null.");
        return this.resources.getResourceInterfaces__ResourceRepository().stream().filter(x -> x.getEntityName().equals(resource.getResourceName())).findFirst().get();
    }
}

