/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.operation;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.connector.IContextRoleCombinator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;

public class OperationProvidedRoleSelector<T> {
    private final IContextRoleCombinator<OperationProvidedRole, T> combinator;
    private final AssemblyContext context;

    public OperationProvidedRoleSelector(IContextRoleCombinator<OperationProvidedRole, T> combinator, AssemblyContext context) {
        this.combinator = combinator;
        this.context = context;
    }

    public T withOperationProvidedRole(OperationProvidedRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        return this.combinator.combineContextAndRole(this.context, role);
    }

    public T withOperationProvidedRole(String name) throws NoSuchElementException {
        ProvidedRole role = this.context.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No OperationProvidedRole with name '%s' found.", name)));
        try {
            return this.withOperationProvidedRole((OperationProvidedRole)role);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("A Role with name '%s' was found, but it was not an OperationProvidedRole. Please make sure all names are unique.%n%s", name), e);
        }
    }
}

