/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class BranchActionCreator
extends GeneralAction {
    private final List<AbstractBranchTransition> branches;

    protected BranchActionCreator(SeffCreator seff) {
        this.seff = seff;
        this.branches = new ArrayList<AbstractBranchTransition>();
    }

    @Override
    public BranchActionCreator withName(String name) {
        return (BranchActionCreator)super.withName(name);
    }

    public BranchActionCreator withGuardedBranchTransition(String branchConditionStochasticExpression, Seff branchActions, String name) {
        ResourceDemandingSEFF build;
        IllegalArgumentException.throwIfNull(branchConditionStochasticExpression, "branchCondition_stochasticExpression must not be null");
        IllegalArgumentException.throwIfNull(branchActions, "branchActions must not be null");
        GuardedBranchTransition branch = SeffFactory.eINSTANCE.createGuardedBranchTransition();
        if (name != null) {
            branch.setEntityName(name);
        }
        if ((build = branchActions.buildRDSeff()).getDescribedService__SEFF() == null && build.getResourceDemandingInternalBehaviours().isEmpty()) {
            branchBody = branchActions.buildBehaviour();
            branch.setBranchBehaviour_BranchTransition((ResourceDemandingBehaviour)branchBody);
        } else {
            branchBody = branchActions.buildRDSeff();
            branch.setBranchBehaviour_BranchTransition((ResourceDemandingBehaviour)branchBody);
        }
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(branchConditionStochasticExpression);
        branch.setBranchCondition_GuardedBranchTransition(rand);
        this.branches.add((AbstractBranchTransition)branch);
        return this;
    }

    public BranchActionCreator withGuardedBranchTransition(String branchConditionStochasticExpression, SeffCreator branchActions) {
        return this.withGuardedBranchTransition(branchConditionStochasticExpression, branchActions, null);
    }

    public BranchActionCreator withProbabilisticBranchTransition(double branchProbability, SeffCreator branchActions, String name) {
        ResourceDemandingSEFF build;
        IllegalArgumentException.throwIfNull(branchActions, "branchActions must not be null");
        ProbabilisticBranchTransition branch = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
        if (name != null) {
            branch.setEntityName(name);
        }
        if ((build = branchActions.buildRDSeff()).getDescribedService__SEFF() == null && build.getSeffTypeID() == null && build.getResourceDemandingInternalBehaviours().isEmpty()) {
            branch.setBranchBehaviour_BranchTransition(branchActions.buildBehaviour());
        } else {
            branch.setBranchBehaviour_BranchTransition((ResourceDemandingBehaviour)build);
        }
        branch.setBranchProbability(branchProbability);
        this.branches.add((AbstractBranchTransition)branch);
        return this;
    }

    public BranchActionCreator withProbabilisticBranchTransition(Double branchProbability, SeffCreator branchActions) {
        return this.withProbabilisticBranchTransition(branchProbability, branchActions, null);
    }

    @Override
    public BranchActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (BranchActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public BranchActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (BranchActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public BranchActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (BranchActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected BranchAction build() {
        BranchAction action = SeffFactory.eINSTANCE.createBranchAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        action.getBranches_Branch().addAll(this.branches);
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

