/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.seff.EmitEventAction;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class EmitEventActionCreator
extends SeffAction {
    private EventType eventType;
    private SourceRole requiredRole;
    private final List<VariableUsage> inputVariableUsages;

    protected EmitEventActionCreator(SeffCreator seff) {
        this.seff = seff;
        this.inputVariableUsages = new ArrayList<VariableUsage>();
    }

    @Override
    public EmitEventActionCreator withName(String name) {
        return (EmitEventActionCreator)super.withName(name);
    }

    public EmitEventActionCreator withEventType(EventType eventType) {
        IllegalArgumentException.throwIfNull(eventType, "eventType must not be null");
        this.eventType = eventType;
        return this;
    }

    public EmitEventActionCreator withSourceRole(SourceRole sourceRole) {
        IllegalArgumentException.throwIfNull(sourceRole, "sourceRole must not be null");
        this.requiredRole = sourceRole;
        return this;
    }

    public EmitEventActionCreator withInputVariableUsage(VariableUsageCreator variableUsage) {
        IllegalArgumentException.throwIfNull(variableUsage, "variableUsage must not be null");
        this.inputVariableUsages.add(variableUsage.build());
        return this;
    }

    protected EmitEventAction build() {
        EmitEventAction action = SeffFactory.eINSTANCE.createEmitEventAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.eventType != null) {
            action.setEventType__EmitEventAction(this.eventType);
        }
        if (this.requiredRole != null) {
            action.setSourceRole__EmitEventAction(this.requiredRole);
        }
        action.getInputVariableUsages__CallAction().addAll(this.inputVariableUsages);
        return action;
    }
}

