/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.InternalSeff;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;

public class ForkActionCreator
extends GeneralAction {
    private final List<ForkedBehaviour> asynchronousForkedBehaviours;
    private final List<ForkedBehaviour> synchronousForkedBehaviours;
    private final List<VariableUsage> variableUsages;

    protected ForkActionCreator(SeffCreator seff) {
        this.seff = seff;
        this.asynchronousForkedBehaviours = new ArrayList<ForkedBehaviour>();
        this.synchronousForkedBehaviours = new ArrayList<ForkedBehaviour>();
        this.variableUsages = new ArrayList<VariableUsage>();
    }

    @Override
    public ForkActionCreator withName(String name) {
        return (ForkActionCreator)super.withName(name);
    }

    public ForkActionCreator withOutputParameterUsageAtSynchronisationPoint(VariableUsageCreator variableUsage) {
        IllegalArgumentException.throwIfNull(variableUsage, "variableUsage must not be null");
        this.variableUsages.add(variableUsage.build());
        return this;
    }

    public ForkActionCreator withSynchronousForkedBehaviourAtSynchronisationPoint(InternalSeff forkedBehaviour) {
        IllegalArgumentException.throwIfNull(forkedBehaviour, "forkedBehaviour must not be null");
        ForkedBehaviour fork = forkedBehaviour.buildForkedBehaviour();
        this.synchronousForkedBehaviours.add(fork);
        return this;
    }

    public ForkActionCreator withAsynchronousForkedBehaviour(InternalSeff forkedBehaviour) {
        IllegalArgumentException.throwIfNull(forkedBehaviour, "forkedBehaviour must not be null");
        ForkedBehaviour fork = forkedBehaviour.buildForkedBehaviour();
        this.asynchronousForkedBehaviours.add(fork);
        return this;
    }

    @Override
    public ForkActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (ForkActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public ForkActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (ForkActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public ForkActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (ForkActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected ForkAction build() {
        ForkAction action = SeffFactory.eINSTANCE.createForkAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        action.getAsynchronousForkedBehaviours_ForkAction().addAll(this.asynchronousForkedBehaviours);
        SynchronisationPoint synch = SeffFactory.eINSTANCE.createSynchronisationPoint();
        synch.getOutputParameterUsage_SynchronisationPoint().addAll(this.variableUsages);
        synch.getSynchronousForkedBehaviours_SynchronisationPoint().addAll(this.synchronousForkedBehaviours);
        action.setSynchronisingBehaviours_ForkAction(synch);
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

