/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.interfaces;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Failure;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class EventTypeCreator
extends RepositoryEntity {
    private Parameter parameter;
    private final List<FailureType> failureTypes = new ArrayList<FailureType>();
    private final List<ExceptionType> exceptionTypes = new ArrayList<ExceptionType>();

    public EventTypeCreator(RepositoryCreator repo) {
        this.repository = repo;
    }

    @Override
    public EventTypeCreator withName(String name) {
        return (EventTypeCreator)super.withName(name);
    }

    public EventTypeCreator withParameter(String name, Primitive dataType, ParameterModifier modifier) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        PrimitiveDataType dt = this.repository.getPrimitiveDataType(dataType);
        return this.withParameter(name, (DataType)dt, modifier);
    }

    public EventTypeCreator withParameter(String name, DataType dataType, ParameterModifier modifier) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        Parameter param = RepositoryFactory.eINSTANCE.createParameter();
        param.setParameterName(name);
        param.setDataType__Parameter(dataType);
        if (modifier != null) {
            param.setModifier__Parameter(modifier);
        }
        this.parameter = param;
        this.repository.addParameter(param);
        return this;
    }

    public EventTypeCreator withFailureType(FailureType failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        this.failureTypes.add(failureType);
        return this;
    }

    public EventTypeCreator withFailureType(Failure failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        FailureType failure = this.repository.getFailureType(failureType);
        return this.withFailureType(failure);
    }

    public EventTypeCreator withExceptionType(ExceptionType exceptionType) {
        IllegalArgumentException.throwIfNull(exceptionType, "exceptionType must not be null");
        this.exceptionTypes.add(exceptionType);
        return this;
    }

    protected EventType build() {
        EventType et = RepositoryFactory.eINSTANCE.createEventType();
        if (this.name != null) {
            et.setEntityName(this.name);
        }
        if (this.parameter != null) {
            et.setParameter__EventType(this.parameter);
        }
        et.getFailureType().addAll(this.failureTypes);
        et.getExceptions__Signature().addAll(this.exceptionTypes);
        return et;
    }
}

