/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.interfaces;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Failure;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class InfrastructureSignatureCreator
extends RepositoryEntity {
    private final List<Parameter> parameters;
    private final List<ExceptionType> exceptions;
    private final List<FailureType> failures;

    public InfrastructureSignatureCreator(RepositoryCreator repository) {
        this.repository = repository;
        this.parameters = new ArrayList<Parameter>();
        this.exceptions = new ArrayList<ExceptionType>();
        this.failures = new ArrayList<FailureType>();
    }

    @Override
    public InfrastructureSignatureCreator withName(String name) {
        return (InfrastructureSignatureCreator)super.withName(name);
    }

    public InfrastructureSignatureCreator withParameter(String name, Primitive dataType, ParameterModifier modifier) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        PrimitiveDataType dt = this.repository.getPrimitiveDataType(dataType);
        return this.withParameter(name, (DataType)dt, modifier);
    }

    public InfrastructureSignatureCreator withParameter(String name, DataType dataType, ParameterModifier modifier) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        IllegalArgumentException.throwIfNull(dataType, "dataType must not be null");
        Parameter param = RepositoryFactory.eINSTANCE.createParameter();
        param.setParameterName(name);
        param.setDataType__Parameter(dataType);
        if (modifier != null) {
            param.setModifier__Parameter(modifier);
        }
        this.parameters.add(param);
        this.repository.addParameter(param);
        return this;
    }

    public InfrastructureSignatureCreator withFailureType(FailureType failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        this.failures.add(failureType);
        return this;
    }

    public InfrastructureSignatureCreator withFailureType(Failure failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        FailureType failure = this.repository.getFailureType(failureType);
        return this.withFailureType(failure);
    }

    public InfrastructureSignatureCreator withExceptionType(ExceptionType exceptionType) {
        IllegalArgumentException.throwIfNull(exceptionType, "exceptionType must not be null");
        this.exceptions.add(exceptionType);
        return this;
    }

    protected InfrastructureSignature build() {
        InfrastructureSignature sig = RepositoryFactory.eINSTANCE.createInfrastructureSignature();
        if (this.name != null) {
            sig.setEntityName(this.name);
        }
        sig.getParameters__InfrastructureSignature().addAll(this.parameters);
        sig.getExceptions__Signature().addAll(this.exceptions);
        sig.getFailureType().addAll(this.failures);
        return sig;
    }
}

