/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.repository.EventGroup;

public class EventChannelCreator
extends SystemEntity {
    private EventGroup eventGroup;

    public EventChannelCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public EventChannelCreator withEventGroup(EventGroup eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "The given EventGroup must not be null.");
        this.eventGroup = eventGroup;
        return this;
    }

    public EventChannelCreator withEventGroup(String name) throws NoSuchElementException {
        EventGroup group;
        try {
            group = (EventGroup)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an EventGroup. Please make sure all names are unique.", name), e);
        }
        return this.withEventGroup(group);
    }

    public EventChannel build() {
        EventChannel channel = CompositionFactory.eINSTANCE.createEventChannel();
        if (this.name != null) {
            channel.setEntityName(this.name);
        }
        channel.setEventGroup__EventChannel(this.eventGroup);
        return channel;
    }

    @Override
    public EventChannelCreator withName(String name) {
        return (EventChannelCreator)super.withName(name);
    }
}

