/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.event;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.event.SourceRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.SourceDelegationConnector;
import org.palladiosimulator.pcm.repository.SourceRole;

public class SourceDelegationConnectorCreator
extends AbstractConnectorCreator {
    private SourceRole outerRole;
    private SourceRole innerRole;
    private AssemblyContext assemblyContext;

    public SourceDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public SourceDelegationConnectorCreator withOuterSourceRole(SourceRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        this.outerRole = role;
        return this;
    }

    public SourceDelegationConnectorCreator withOuterSourceRole(String name) throws NoSuchElementException {
        SourceRole role = this.system.getSystemSourceRoleByName(name);
        return this.withOuterSourceRole(role);
    }

    public SourceRoleSelector<SourceDelegationConnectorCreator> withAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new SourceRoleSelector<SourceDelegationConnectorCreator>((context1, role) -> {
            this.assemblyContext = context1;
            this.innerRole = role;
            return this;
        }, context);
    }

    public SourceRoleSelector<SourceDelegationConnectorCreator> withAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withAssemblyContext(context);
    }

    public SourceDelegationConnector build() {
        SourceDelegationConnector connector = CompositionFactory.eINSTANCE.createSourceDelegationConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setAssemblyContext__SourceDelegationConnector(this.assemblyContext);
        connector.setOuterSourceRole__SourceRole(this.outerRole);
        connector.setInnerSourceRole__SourceRole(this.innerRole);
        return connector;
    }

    @Override
    public SourceDelegationConnectorCreator withName(String name) {
        return (SourceDelegationConnectorCreator)super.withName(name);
    }
}

