/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.infrastructure;

import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.infrastructure.InfrastructureRequiredRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;

public class RequiredInfrastructureDelegationConnectorCreator
extends AbstractConnectorCreator {
    private InfrastructureRequiredRole outerRequiredRole;
    private InfrastructureRequiredRole innerRequiredRole;
    private AssemblyContext requringAssemblyContext;

    public RequiredInfrastructureDelegationConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public RequiredInfrastructureDelegationConnectorCreator withOuterRequiredRole(InfrastructureRequiredRole role) {
        this.outerRequiredRole = role;
        return this;
    }

    public RequiredInfrastructureDelegationConnectorCreator withOuterRequiredRole(String name) throws NoSuchElementException {
        InfrastructureRequiredRole role = this.system.getSystemInfrastructureRequiredRoleByName(name);
        return this.withOuterRequiredRole(role);
    }

    public InfrastructureRequiredRoleSelector<RequiredInfrastructureDelegationConnectorCreator> withRequiringContext(AssemblyContext context) {
        return new InfrastructureRequiredRoleSelector<RequiredInfrastructureDelegationConnectorCreator>((context1, role) -> {
            this.requringAssemblyContext = context1;
            this.innerRequiredRole = role;
            return this;
        }, context);
    }

    public InfrastructureRequiredRoleSelector<RequiredInfrastructureDelegationConnectorCreator> withRequiringContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withRequiringContext(context);
    }

    public RequiredInfrastructureDelegationConnector build() {
        RequiredInfrastructureDelegationConnector connector = CompositionFactory.eINSTANCE.createRequiredInfrastructureDelegationConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setAssemblyContext__RequiredInfrastructureDelegationConnector(this.requringAssemblyContext);
        connector.setOuterRequiredRole__RequiredInfrastructureDelegationConnector(this.outerRequiredRole);
        connector.setInnerRequiredRole__RequiredInfrastructureDelegationConnector(this.innerRequiredRole);
        return connector;
    }

    @Override
    public RequiredInfrastructureDelegationConnectorCreator withName(String name) {
        return (RequiredInfrastructureDelegationConnectorCreator)super.withName(name);
    }
}

