/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.operation;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.operation.OperationProvidedRoleSelector;
import org.palladiosimulator.generator.fluent.system.structure.connector.operation.OperationRequiredRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;

public class AssemblyConnectorCreator
extends AbstractConnectorCreator {
    private AssemblyContext requiringContext;
    private OperationRequiredRole requiredRole;
    private AssemblyContext providingContext;
    private OperationProvidedRole providedRole;

    public AssemblyConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public OperationRequiredRoleSelector<AssemblyConnectorCreator> withRequiringAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new OperationRequiredRoleSelector<AssemblyConnectorCreator>((reqContext, role) -> {
            this.requiringContext = reqContext;
            this.requiredRole = role;
            return this;
        }, context);
    }

    public OperationRequiredRoleSelector<AssemblyConnectorCreator> withRequiringAssemblyContext(String name) throws NoSuchElementException {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withRequiringAssemblyContext(context);
    }

    public OperationProvidedRoleSelector<AssemblyConnectorCreator> withProvidingAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new OperationProvidedRoleSelector<AssemblyConnectorCreator>((provContext, role) -> {
            this.providingContext = provContext;
            this.providedRole = role;
            return this;
        }, context);
    }

    public OperationProvidedRoleSelector<AssemblyConnectorCreator> withProvidingAssemblyContext(String name) throws NoSuchElementException {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withProvidingAssemblyContext(context);
    }

    public AssemblyConnector build() {
        AssemblyConnector connector = CompositionFactory.eINSTANCE.createAssemblyConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setRequiringAssemblyContext_AssemblyConnector(this.requiringContext);
        connector.setRequiredRole_AssemblyConnector(this.requiredRole);
        connector.setProvidingAssemblyContext_AssemblyConnector(this.providingContext);
        connector.setProvidedRole_AssemblyConnector(this.providedRole);
        return connector;
    }

    @Override
    public AssemblyConnectorCreator withName(String name) {
        return (AssemblyConnectorCreator)super.withName(name);
    }
}

