/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.mdsdprofiles.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.mdsdprofiles.provider.StereotypableElementItemPropertyDescriptorDecorator;

public class StereotypableElementItemProviderDecorator
extends ItemProviderDecorator
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
Adapter {
    protected static final List<Integer> EXLUDED_FEATURE_IDS = Arrays.asList(0, 1, 2);

    public StereotypableElementItemProviderDecorator(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        if (this.notStereotyped(object)) {
            return super.getText(object);
        }
        EObject stereotypedElement = (EObject)object;
        StringBuilder stringBuilder = new StringBuilder();
        for (Stereotype stereotype : StereotypeAPI.getAppliedStereotypes(stereotypedElement)) {
            stringBuilder.append("\u00ab").append(stereotype.getName()).append("\u00bb ");
        }
        return stringBuilder.append(super.getText(object)).toString();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.notStereotyped(object)) {
            return super.getPropertyDescriptors(object);
        }
        EObject stereotypedElement = (EObject)object;
        LinkedList<IItemPropertyDescriptor> propertyDescriptors = new LinkedList<IItemPropertyDescriptor>(super.getPropertyDescriptors((Object)stereotypedElement));
        this.addTaggedValuesPropertyDescriptors(propertyDescriptors, stereotypedElement);
        return propertyDescriptors;
    }

    private void addTaggedValuesPropertyDescriptors(List<IItemPropertyDescriptor> propertyDescriptors, EObject stereotypedElement) {
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications(stereotypedElement)) {
            IItemPropertySource stereotypeApplicationPropertySource = (IItemPropertySource)this.getAdapterFactory().adapt((Notifier)stereotypeApplication, IItemPropertySource.class);
            List stereotypePropertyDescriptors = stereotypeApplicationPropertySource.getPropertyDescriptors((Object)stereotypeApplication);
            for (IItemPropertyDescriptor stereotypePropertyDescriptor : stereotypePropertyDescriptors) {
                EStructuralFeature feature = (EStructuralFeature)stereotypePropertyDescriptor.getFeature(null);
                if (EXLUDED_FEATURE_IDS.contains(feature.getFeatureID())) continue;
                propertyDescriptors.add((IItemPropertyDescriptor)new StereotypableElementItemPropertyDescriptorDecorator(stereotypeApplication, stereotypePropertyDescriptor));
            }
        }
    }

    public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyId) {
        if (this.notStereotyped(object)) {
            return super.getPropertyDescriptor(object, propertyId);
        }
        for (IItemPropertyDescriptor propertyDescriptor : this.getPropertyDescriptors(object)) {
            if (!propertyDescriptor.getId(object).equals(propertyId)) continue;
            return propertyDescriptor;
        }
        throw new RuntimeException("Problem finding property ID -- no clue why :(");
    }

    public Notifier getTarget() {
        return ((Adapter)this.getDecoratedItemProvider()).getTarget();
    }

    public void setTarget(Notifier newTarget) {
        ((Adapter)this.getDecoratedItemProvider()).setTarget(newTarget);
    }

    public void notifyChanged(Notification notification) {
        if (this.isChangeOfStereotype(notification)) {
            this.informViewerAboutLabelUpdate(notification);
        } else {
            super.notifyChanged(notification);
        }
    }

    private boolean notStereotyped(Object object) {
        return !(object instanceof EObject) || !StereotypeAPI.hasStereotypeApplications((EObject)object);
    }

    private void informViewerAboutLabelUpdate(Notification notification) {
        this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
    }

    private boolean isChangeOfStereotype(Notification notification) {
        return notification.getEventType() == 1002 || notification.getEventType() == 1003;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        LinkedList newResult = new LinkedList();
        for (Object o : result) {
            if (o instanceof ProfileApplication) continue;
            newResult.add(o);
        }
        return newResult;
    }
}

