/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementframework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.measurementframework.measureprovider.MeasurementListMeasureProvider;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;

public final class TupleMeasurement
extends MeasuringValue {
    private final IMeasureProvider measureProvider;
    private final List<MeasuringValue> subsumedMeasurements;

    public TupleMeasurement(List<MeasuringValue> subsumedMeasurements, MetricSetDescription metricSetDescription) {
        super((MetricDescription)metricSetDescription);
        this.subsumedMeasurements = subsumedMeasurements;
        this.measureProvider = new MeasurementListMeasureProvider(subsumedMeasurements);
        if (subsumedMeasurements.size() != metricSetDescription.getSubsumedMetrics().size()) {
            throw new IllegalArgumentException("Number of measurements has to match the number of child metrics in the metric set description");
        }
        int i = 0;
        for (MetricDescription subsumedMetric : metricSetDescription.getSubsumedMetrics()) {
            if (subsumedMeasurements.get(i++).getMetricDesciption().getId().equals(subsumedMetric.getId())) continue;
            throw new IllegalArgumentException("Subsumed metric \"" + subsumedMetric.getName() + "\" of metric \"" + metricSetDescription.getName() + "\" not present in measurement");
        }
    }

    public TupleMeasurement(MetricSetDescription metricDescription, Measure<?, ?> ... measures) {
        this(metricDescription, Arrays.asList(measures));
    }

    public TupleMeasurement(MetricSetDescription metricDescription, List<Measure<?, ?>> measures) {
        this(TupleMeasurement.computeSubsumedMeasurements(metricDescription, measures), metricDescription);
    }

    private static List<MeasuringValue> computeSubsumedMeasurements(MetricSetDescription metricDescription, List<Measure<?, ?>> measures) {
        ArrayList<MeasuringValue> subsumedMeasurements = new ArrayList<MeasuringValue>();
        int i = 0;
        for (Measure<?, ?> measure : measures) {
            MetricDescription subsumedMetric = (MetricDescription)metricDescription.getSubsumedMetrics().get(i++);
            if (subsumedMetric instanceof BaseMetricDescription) {
                subsumedMeasurements.add(new BasicMeasurement(measure, (BaseMetricDescription)subsumedMetric));
                continue;
            }
            if (subsumedMetric instanceof MetricSetDescription) {
                subsumedMeasurements.add(new TupleMeasurement((MetricSetDescription)subsumedMetric, measure));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of Metric Description");
        }
        return subsumedMeasurements;
    }

    @Override
    public List<Measure<?, ?>> asList() {
        return this.measureProvider.asList();
    }

    public <V, Q extends Quantity> Measure<V, Q> getMeasureForMetric(MetricDescription wantedMetric) {
        return this.measureProvider.getMeasureForMetric(wantedMetric);
    }

    public List<MeasuringValue> getSubsumedMeasurements() {
        return Collections.unmodifiableList(this.subsumedMeasurements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TupleMeasurement [");
        for (Measure<?, ?> sub : this.asList()) {
            sb.append(sub.toString());
            sb.append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public MeasuringValue getMeasuringValueForMetric(MetricDescription metricDesciption) {
        if (MetricSpecPackage.eINSTANCE.getBaseMetricDescription().isInstance((Object)metricDesciption) && MetricSpecPackage.eINSTANCE.getMetricSetDescription().isInstance((Object)this.getMetricDesciption())) {
            for (MeasuringValue curMeasurement : this.subsumedMeasurements) {
                MeasuringValue value = curMeasurement.getMeasuringValueForMetric(metricDesciption);
                if (value == null) continue;
                return value;
            }
        } else if (!metricDesciption.getId().equals(this.getMetricDesciption().getId())) {
            return null;
        }
        return this;
    }
}

