/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementframework.measureprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.measure.Measure;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.AbstractMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;

public class MeasurementListMeasureProvider
extends AbstractMeasureProvider {
    private final List<MeasuringValue> measurements;

    public MeasurementListMeasureProvider(List<MeasuringValue> measurements) {
        this.measurements = measurements;
    }

    @Override
    public MeasuringValue getMeasurementForMetric(MetricDescription wantedMetric) {
        for (MeasuringValue subsubmedMeasurement : this.measurements) {
            MeasuringValue subsubmedMeasure = subsubmedMeasurement.getMeasuringValueForMetric(wantedMetric);
            if (subsubmedMeasure == null) continue;
            return subsubmedMeasure;
        }
        return null;
    }

    @Override
    public final List<Measure<?, ?>> asList() {
        ArrayList result = new ArrayList();
        for (MeasuringValue m : this.measurements) {
            result.addAll(m.asList());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataTuple [");
        for (Measure<?, ?> m : this.asList()) {
            sb.append(String.valueOf(m.toString()) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public final List<MeasuringValue> getSubsumedMeasurements() {
        return Collections.unmodifiableList(this.measurements);
    }
}

