/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumMap;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelType;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MeasuringPointSelectionWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MetricDescriptionSelectionWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MonitorCreationWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.ProcessingTypeSelectionWizardModel;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;

public class WizardModelManager {
    private Monitor monitor;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private ResourceEditorImpl editor;
    private DataApplication dataApp;
    private boolean isEditing;
    private EnumMap<WizardModelType, WizardModel> wizardModels = new EnumMap(WizardModelType.class);

    public WizardModelManager() {
        this.monitor = MonitorRepositoryFactory.eINSTANCE.createMonitor();
        this.dataApp = DataApplication.getInstance();
        this.editor = ResourceEditorImpl.getInstance();
    }

    public WizardModelManager(Monitor monitor) {
        this.monitor = monitor;
        this.dataApp = DataApplication.getInstance();
        this.editor = ResourceEditorImpl.getInstance();
        this.isEditing = true;
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)monitor);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.flush();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void cancel() {
        if (this.isEditing) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.monitor);
            CommandStack commandStack = editingDomain.getCommandStack();
            while (commandStack.canUndo()) {
                editingDomain.getCommandStack().undo();
            }
        } else {
            this.monitor = null;
        }
    }

    public void finish() {
        MeasuringPoint measuringPoint = this.monitor.getMeasuringPoint();
        if (this.monitor.getMonitorRepository() == null) {
            this.editor.addMonitorToRepository((EObject)this.dataApp.getMonitorRepository(), (EObject)this.monitor);
        }
        if (measuringPoint.getMeasuringPointRepository() == null) {
            this.editor.addMeasuringPointToRepository((EObject)this.dataApp.getModelAccessor().getMeasuringPointRepositoryList().get(0), (EObject)measuringPoint);
            this.editor.setMeasuringPointToMonitor((EObject)this.monitor, measuringPoint);
        }
        this.changes.firePropertyChange("save", 1, 2);
    }

    public boolean canFinish() {
        return this.getWizardModel(WizardModelType.MONITOR_CREATION).canFinish() && this.getWizardModel(WizardModelType.MEASURING_POINT_SELECTION).canFinish() && this.getWizardModel(WizardModelType.METRIC_DESCRIPTION_SELECTION).canFinish() && this.getWizardModel(WizardModelType.PROCESSING_TYPE).canFinish();
    }

    public WizardModel getWizardModel(WizardModelType wizardModelType) {
        WizardModel newWizardModel;
        if (this.wizardModels.containsKey((Object)wizardModelType)) {
            return this.wizardModels.get((Object)wizardModelType);
        }
        switch (wizardModelType) {
            case MONITOR_CREATION: {
                newWizardModel = new MonitorCreationWizardModel(this.monitor, this.isEditing);
                break;
            }
            case MEASURING_POINT_SELECTION: {
                newWizardModel = new MeasuringPointSelectionWizardModel(this.monitor, this.isEditing);
                break;
            }
            case METRIC_DESCRIPTION_SELECTION: {
                newWizardModel = new MetricDescriptionSelectionWizardModel(this.monitor, this.isEditing);
                break;
            }
            case PROCESSING_TYPE: {
                newWizardModel = new ProcessingTypeSelectionWizardModel(this.monitor, this.isEditing);
                break;
            }
            default: {
                return null;
            }
        }
        this.wizardModels.put(wizardModelType, newWizardModel);
        return newWizardModel;
    }
}

