/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import javax.measure.Measure;
import javax.measure.unit.Unit;
import org.palladiosimulator.measurementsui.dataprovider.SloProvider;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelSlo;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.servicelevelobjective.HardThreshold;
import org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectiveFactory;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectivePackage;
import org.palladiosimulator.servicelevelobjective.Threshold;

public class SloThresholdWizardModel
implements WizardModelSlo {
    private boolean isFinishable = false;
    private ServicelevelObjectivePackage serviceLevelObjectivePackage = ServicelevelObjectivePackage.eINSTANCE;
    private ServicelevelObjectiveFactory servicelevelObjectiveFactory = this.serviceLevelObjectivePackage.getServicelevelObjectiveFactory();
    private SloProvider sloProvider;
    private static final String PAGE_TITLE = "Create Thresholds";
    private static final String PAGE_DESCRIPTION = "On this page thresholds for Service Level Objectives can be created and edited. \n\nSome thresholds need a specific unit. Time driven measurement specifications for example can be set with seconds (s) or milliseconds (ms)";

    public SloThresholdWizardModel(SloProvider dataProvider, boolean isEditing) {
        this.sloProvider = dataProvider;
    }

    @Override
    public boolean canFinish() {
        return this.isFinishable;
    }

    public void setFinishable(boolean isFinishable) {
        this.isFinishable = isFinishable;
    }

    @Override
    public String getInfoText() {
        return PAGE_DESCRIPTION;
    }

    @Override
    public String getTitleText() {
        return PAGE_TITLE;
    }

    public ServiceLevelObjective getSlo() {
        return this.sloProvider.getServiceLevelObjective();
    }

    public void setLowerThreshold(Float hard, String hardUnit, Float fuzzy, String fuzzyUnit, fuzzyThresholdType type) {
        Unit f = Unit.valueOf((CharSequence)fuzzyUnit);
        Unit h = Unit.valueOf((CharSequence)hardUnit);
        try {
            f = Unit.valueOf((CharSequence)fuzzyUnit);
            h = Unit.valueOf((CharSequence)hardUnit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = null;
            h = null;
        }
        Measure fValue = Measure.valueOf((float)fuzzy.floatValue(), (Unit)f);
        Measure hValue = Measure.valueOf((float)hard.floatValue(), (Unit)h);
        LinearFuzzyThreshold lower = switch (type) {
            case fuzzyThresholdType.LINEAR -> this.servicelevelObjectiveFactory.createLinearFuzzyThreshold();
            case fuzzyThresholdType.QUADRATIC -> this.servicelevelObjectiveFactory.createQuadraticFuzzyThreshold();
            case fuzzyThresholdType.NEGATIVE_QUADRATIC -> this.servicelevelObjectiveFactory.createNegativeQuadraticFuzzyThreshold();
            default -> this.servicelevelObjectiveFactory.createLinearFuzzyThreshold();
        };
        lower.setSoftLimit(fValue);
        lower.setThresholdLimit(hValue);
        this.sloProvider.getServiceLevelObjective().setLowerThreshold((Threshold)lower);
    }

    public void setLowerThreshold(Float hard, String hardUnit) {
        Unit h;
        try {
            h = Unit.valueOf((CharSequence)hardUnit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            h = null;
        }
        Measure hValue = Measure.valueOf((float)hard.floatValue(), (Unit)h);
        HardThreshold lower = this.servicelevelObjectiveFactory.createHardThreshold();
        lower.setThresholdLimit(hValue);
        this.sloProvider.getServiceLevelObjective().setLowerThreshold((Threshold)lower);
    }

    public void setUpperThreshold(Float hard, String hardUnit, Float fuzzy, String fuzzyUnit, fuzzyThresholdType type) {
        Unit f = Unit.valueOf((CharSequence)fuzzyUnit);
        Unit h = Unit.valueOf((CharSequence)hardUnit);
        try {
            f = Unit.valueOf((CharSequence)fuzzyUnit);
            h = Unit.valueOf((CharSequence)hardUnit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = null;
            h = null;
        }
        Measure fValue = Measure.valueOf((float)fuzzy.floatValue(), (Unit)f);
        Measure hValue = Measure.valueOf((float)hard.floatValue(), (Unit)h);
        LinearFuzzyThreshold upper = switch (type) {
            case fuzzyThresholdType.LINEAR -> this.servicelevelObjectiveFactory.createLinearFuzzyThreshold();
            case fuzzyThresholdType.QUADRATIC -> this.servicelevelObjectiveFactory.createQuadraticFuzzyThreshold();
            case fuzzyThresholdType.NEGATIVE_QUADRATIC -> this.servicelevelObjectiveFactory.createNegativeQuadraticFuzzyThreshold();
            default -> this.servicelevelObjectiveFactory.createLinearFuzzyThreshold();
        };
        upper.setSoftLimit(fValue);
        upper.setThresholdLimit(hValue);
        this.sloProvider.getServiceLevelObjective().setUpperThreshold((Threshold)upper);
    }

    public void setUpperThreshold(Float hard, String hardUnit) {
        Unit h;
        try {
            h = Unit.valueOf((CharSequence)hardUnit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            h = null;
        }
        Measure hValue = Measure.valueOf((float)hard.floatValue(), (Unit)h);
        HardThreshold upper = this.servicelevelObjectiveFactory.createHardThreshold();
        upper.setThresholdLimit(hValue);
        this.sloProvider.getServiceLevelObjective().setUpperThreshold((Threshold)upper);
    }

    public Unit<?> getDefaultUnit() {
        try {
            NumericalBaseMetricDescription specification = (NumericalBaseMetricDescription)this.sloProvider.getMeasurementSpecification().getMetricDescription();
            return specification.getDefaultUnit();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String getSpecificationType() {
        MeasurementSpecification msp = this.sloProvider.getMeasurementSpecification();
        return msp.getProcessingType().toString();
    }

    public void deleteLowerThreshold() {
        this.sloProvider.getServiceLevelObjective().setLowerThreshold(null);
    }

    public void deleteUpperThreshold() {
        this.sloProvider.getServiceLevelObjective().setUpperThreshold(null);
    }

    public boolean sloIsNull() {
        return this.sloProvider.getServiceLevelObjective().equals(null);
    }

    public static enum fuzzyThresholdType {
        LINEAR,
        QUADRATIC,
        NEGATIVE_QUADRATIC;

    }
}

