/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.dataprovider;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.palladiosimulator.measurementsui.fileaccess.ModelAccessor;
import org.palladiosimulator.measurementsui.fileaccess.ValidProjectAccessor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataApplication {
    private ValidProjectAccessor validProjectAccessor;
    private ModelAccessor modelAccessor;
    private Session session;
    private URI sessionResourceURI;
    private IProject project;
    private MonitorRepository monitorRepository;
    private ServiceLevelObjectiveRepository sloRepository;
    private static DataApplication instance;
    private final Logger logger = LoggerFactory.getLogger(DataApplication.class);

    private DataApplication() {
        this.validProjectAccessor = new ValidProjectAccessor();
        this.modelAccessor = new ModelAccessor();
    }

    public static DataApplication getInstance() {
        if (instance == null) {
            instance = new DataApplication();
        }
        return instance;
    }

    public void loadData(IProject project, int monitorRepositorySelectionIndex, int sloRepositorySelectionIndex) {
        this.project = project;
        this.validProjectAccessor.getAirdFileOfProject(this.project).ifPresent(airdFile -> this.initializeSessionResourceURI((String)airdFile));
        this.initializeSession(this.sessionResourceURI);
        if (this.session != null) {
            this.modelAccessor.initializeModels(this.session);
            this.modelAccessor.checkIfRepositoriesExist(project);
            this.updateMonitorRepository(monitorRepositorySelectionIndex);
            this.updateSLORepository(sloRepositorySelectionIndex);
        } else {
            this.logger.warn("No Models are initiated. Make sure a Session is open.");
        }
    }

    public void updateData(int monitorRepositorySelectionIndex, int sloRepositorySelectionIndex) {
        this.loadData(this.project, monitorRepositorySelectionIndex, sloRepositorySelectionIndex);
    }

    private void initializeSessionResourceURI(String airdPath) {
        try {
            this.sessionResourceURI = URI.createPlatformResourceURI((String)airdPath, (boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            this.logger.warn("No valid path to an air file");
        }
    }

    private void initializeSession(URI sessionResourceURI) {
        try {
            this.session = SessionManager.INSTANCE.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            this.logger.warn("Make sure a Session can be initiated. A valid URI must be present.");
        }
    }

    public void updateMonitorRepository(int selectionIndex) {
        this.monitorRepository = this.modelAccessor.monitorRepositoryExists() && this.modelAccessor.getMonitorRepositoryList().size() > selectionIndex && selectionIndex >= 0 ? this.modelAccessor.getMonitorRepositoryList().get(selectionIndex) : this.modelAccessor.getMonitorRepositoryList().get(0);
    }

    public void updateSLORepository(int selectionIndex) {
        this.sloRepository = this.modelAccessor.sloRepositoryExists() && this.modelAccessor.getSLORepositoryList().size() > selectionIndex && selectionIndex >= 0 ? this.modelAccessor.getSLORepositoryList().get(selectionIndex) : this.modelAccessor.getSLORepositoryList().get(0);
    }

    public ModelAccessor getModelAccessor() {
        return this.modelAccessor;
    }

    public ValidProjectAccessor getValidProjectAccessor() {
        return this.validProjectAccessor;
    }

    public IProject getProject() {
        return this.project;
    }

    public MonitorRepository getMonitorRepository() {
        return this.monitorRepository;
    }

    public ServiceLevelObjectiveRepository getSLORepository() {
        return this.sloRepository;
    }
}

