/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.dataprovider;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class MeasuringPointModelElementProvider {
    private DataApplication dataApplication = DataApplication.getInstance();

    public List<AssemblyContext> getAssemblyContexts() {
        return this.dataApplication.getModelAccessor().getSystemList().stream().flatMap(e -> e.getAssemblyContexts__ComposedStructure().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<ResourceContainer> getResourceContainer() {
        return this.dataApplication.getModelAccessor().getResourceEnvironmenList().stream().flatMap(e -> e.getResourceContainer_ResourceEnvironment().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<ProcessingResourceSpecification> getActiveResources() {
        return this.getResourceContainer().stream().flatMap(e -> e.getActiveResourceSpecifications_ResourceContainer().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<LinkingResource> getLinkingResources() {
        return this.dataApplication.getModelAccessor().getResourceEnvironmenList().stream().flatMap(e -> e.getLinkingResources__ResourceEnvironment().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<UsageScenario> getUsageScenarios() {
        return this.dataApplication.getModelAccessor().getUsageModelList().stream().flatMap(e -> e.getUsageScenario_UsageModel().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<AbstractUserAction> getEntryLevelSystemCalls() {
        LinkedList allActions = new LinkedList();
        LinkedList<AbstractUserAction> onlyEntryLevelSystemCalls = new LinkedList<AbstractUserAction>();
        allActions.addAll(this.getUsageScenarios().stream().flatMap(e -> e.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour().stream()).filter(e -> e instanceof EntryLevelSystemCall || e instanceof Branch || e instanceof BranchTransition || e instanceof Loop).collect(Collectors.toCollection(LinkedList::new)));
        for (AbstractUserAction action : allActions) {
            if (action instanceof EntryLevelSystemCall) {
                onlyEntryLevelSystemCalls.add(action);
                continue;
            }
            if (action instanceof Branch) {
                onlyEntryLevelSystemCalls.addAll(this.getBranchNestedEntryLevelSystemCalls((Branch)action));
                continue;
            }
            if (action instanceof Loop) {
                onlyEntryLevelSystemCalls.addAll(((Loop)action).getBodyBehaviour_Loop().getActions_ScenarioBehaviour().stream().filter(e -> e instanceof EntryLevelSystemCall).collect(Collectors.toCollection(LinkedList::new)));
                continue;
            }
            if (!(action instanceof BranchTransition)) continue;
            onlyEntryLevelSystemCalls.addAll(((BranchTransition)action).getBranchedBehaviour_BranchTransition().getActions_ScenarioBehaviour().stream().filter(e -> e instanceof EntryLevelSystemCall).collect(Collectors.toCollection(LinkedList::new)));
        }
        return onlyEntryLevelSystemCalls;
    }

    private List<AbstractUserAction> getBranchNestedEntryLevelSystemCalls(Branch branch) {
        LinkedList<AbstractUserAction> actions = new LinkedList<AbstractUserAction>();
        for (BranchTransition trans : branch.getBranchTransitions_Branch()) {
            actions.addAll(trans.getBranchedBehaviour_BranchTransition().getActions_ScenarioBehaviour().stream().filter(e -> e instanceof EntryLevelSystemCall).collect(Collectors.toCollection(LinkedList::new)));
        }
        return actions;
    }

    public List<EObject> getExternalCallActions() {
        return this.getSeffs().stream().flatMap(e -> e.eContents().stream()).filter(e -> e instanceof ExternalCallAction).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<EObject> getComponents() {
        return this.dataApplication.getModelAccessor().getRepositoryList().stream().flatMap(e -> e.eContents().stream()).filter(e -> e instanceof BasicComponent).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<EObject> getSeffs() {
        return this.getComponents().stream().flatMap(e -> e.eContents().stream()).filter(e -> e instanceof ResourceDemandingSEFF).collect(Collectors.toCollection(LinkedList::new));
    }
}

