/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.dataprovider;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.monitorrepository.impl.FeedThroughImpl;
import org.palladiosimulator.monitorrepository.impl.FixedSizeAggregationImpl;
import org.palladiosimulator.monitorrepository.impl.TimeDrivenAggregationImpl;
import org.palladiosimulator.monitorrepository.impl.TimeDrivenImpl;
import org.palladiosimulator.monitorrepository.impl.VariableSizeAggregationImpl;

public class ProcessingTypeProvider {
    private static final String RETROSPECTION_LENGTH = "Retrospection Length";
    private static final String WINDOW_LENGTH = "Window Length";
    private static final String WINDOW_INCREMENT = "Window Increment";
    private static final String NUMBER_OF_MEASUREMENTS = "Number of Measurements";
    private static final String FREQUENCY = "Frequency";
    private static final String VARIABLE_SIZE_AGGREGATION = "VariableSizeAggregation";
    private static final String TIME_DRIVEN = "TimeDriven";
    private static final String TIME_DRIVEN_AGGREGATION = "TimeDrivenAggregation";
    private static final String FIXED_SIZE_AGGREGATION = "FixedSizeAggregation";
    private static final String FEED_THROUGH = "FeedThrough";
    private MonitorRepositoryFactory monFactory = MonitorRepositoryPackage.eINSTANCE.getMonitorRepositoryFactory();
    private ResourceEditorImpl editor = ResourceEditorImpl.getInstance();

    public String[] provideBasicProcessingTypes() {
        BasicEList listOfProcessingTypes = new BasicEList();
        listOfProcessingTypes.add((Object)this.monFactory.createFeedThrough());
        listOfProcessingTypes.add((Object)this.monFactory.createFixedSizeAggregation());
        listOfProcessingTypes.add((Object)this.monFactory.createTimeDriven());
        listOfProcessingTypes.add((Object)this.monFactory.createTimeDrivenAggregation());
        listOfProcessingTypes.add((Object)this.monFactory.createVariableSizeAggregation());
        String[] allProcessingTypesArray = new String[5];
        for (EObject aProcessingType : listOfProcessingTypes) {
            if (aProcessingType instanceof FeedThroughImpl) {
                allProcessingTypesArray[0] = FEED_THROUGH;
                continue;
            }
            if (aProcessingType instanceof FixedSizeAggregationImpl) {
                allProcessingTypesArray[1] = FIXED_SIZE_AGGREGATION;
                continue;
            }
            if (aProcessingType instanceof TimeDrivenImpl) {
                if (aProcessingType instanceof TimeDrivenAggregationImpl) {
                    allProcessingTypesArray[3] = TIME_DRIVEN_AGGREGATION;
                    continue;
                }
                allProcessingTypesArray[2] = TIME_DRIVEN;
                continue;
            }
            if (!(aProcessingType instanceof VariableSizeAggregationImpl)) continue;
            allProcessingTypesArray[4] = VARIABLE_SIZE_AGGREGATION;
        }
        return allProcessingTypesArray;
    }

    /*
     * Exception decompiling
     */
    public List<String> provideProcessingTypeProperties(String processingTypeString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl54 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl54 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void assignProcessingTypeToMeasurementSpecification(MeasurementSpecification measurementSpecification, String selectedProcessingType, boolean isEditing) {
        switch (selectedProcessingType) {
            case "FeedThrough": {
                if (isEditing) {
                    this.editor.setProcessingType((EObject)measurementSpecification, (EObject)this.monFactory.createFeedThrough());
                    break;
                }
                measurementSpecification.setProcessingType((ProcessingType)this.monFactory.createFeedThrough());
                break;
            }
            case "FixedSizeAggregation": {
                if (isEditing) {
                    this.editor.setProcessingType((EObject)measurementSpecification, (EObject)this.monFactory.createFixedSizeAggregation());
                    break;
                }
                measurementSpecification.setProcessingType((ProcessingType)this.monFactory.createFixedSizeAggregation());
                break;
            }
            case "TimeDriven": {
                if (isEditing) {
                    this.editor.setProcessingType((EObject)measurementSpecification, (EObject)this.monFactory.createTimeDriven());
                    break;
                }
                measurementSpecification.setProcessingType((ProcessingType)this.monFactory.createTimeDriven());
                break;
            }
            case "TimeDrivenAggregation": {
                if (isEditing) {
                    this.editor.setProcessingType((EObject)measurementSpecification, (EObject)this.monFactory.createTimeDrivenAggregation());
                    break;
                }
                measurementSpecification.setProcessingType((ProcessingType)this.monFactory.createTimeDrivenAggregation());
                break;
            }
            case "VariableSizeAggregation": {
                if (isEditing) {
                    this.editor.setProcessingType((EObject)measurementSpecification, (EObject)this.monFactory.createVariableSizeAggregation());
                    break;
                }
                measurementSpecification.setProcessingType((ProcessingType)this.monFactory.createVariableSizeAggregation());
                break;
            }
        }
    }

    public void setAProcessingTypeAttribute(MeasurementSpecification measurementSpecification, String processingTypeProperty, Double value, boolean isEditing) {
        ProcessingType processingType = measurementSpecification.getProcessingType();
        if (processingType instanceof FixedSizeAggregationImpl) {
            this.setFixedSizeAggregation(processingTypeProperty, value, isEditing, processingType);
        } else if (processingType instanceof TimeDrivenImpl) {
            this.setTimeDriven(processingTypeProperty, value, isEditing, processingType);
        } else if (processingType instanceof VariableSizeAggregationImpl) {
            this.setVariableSizeAggregation(processingTypeProperty, value, isEditing, processingType);
        }
    }

    private void setVariableSizeAggregation(String processingTypeProperty, Double value, boolean isEditing, ProcessingType processingType) {
        if (isEditing) {
            if (processingTypeProperty.equals(FREQUENCY)) {
                this.editor.setAProcessingTypeAttribute((EObject)((VariableSizeAggregationImpl)processingType), "frequency", value.intValue());
            }
            if (processingTypeProperty.equals(RETROSPECTION_LENGTH)) {
                this.editor.setAProcessingTypeAttribute((EObject)((VariableSizeAggregationImpl)processingType), "retrospectionLength", value);
            }
        } else {
            if (processingTypeProperty.equals(FREQUENCY)) {
                ((VariableSizeAggregationImpl)processingType).setFrequency(value.intValue());
            }
            if (processingTypeProperty.equals(RETROSPECTION_LENGTH)) {
                ((VariableSizeAggregationImpl)processingType).setRetrospectionLength(value.doubleValue());
            }
        }
    }

    private void setTimeDriven(String processingTypeProperty, Double value, boolean isEditing, ProcessingType processingType) {
        if (isEditing) {
            if (processingTypeProperty.equals(WINDOW_INCREMENT)) {
                this.editor.setAProcessingTypeAttribute((EObject)((TimeDrivenImpl)processingType), "windowIncrement", value);
            }
            if (processingTypeProperty.equals(WINDOW_LENGTH)) {
                this.editor.setAProcessingTypeAttribute((EObject)((TimeDrivenImpl)processingType), "windowLength", value);
            }
        } else {
            if (processingTypeProperty.equals(WINDOW_INCREMENT)) {
                ((TimeDrivenImpl)processingType).setWindowIncrement(value.doubleValue());
            }
            if (processingTypeProperty.equals(WINDOW_LENGTH)) {
                ((TimeDrivenImpl)processingType).setWindowLength(value.doubleValue());
            }
        }
    }

    private void setFixedSizeAggregation(String processingTypeProperty, Double value, boolean isEditing, ProcessingType processingType) {
        if (isEditing) {
            if (processingTypeProperty.equals(FREQUENCY)) {
                this.editor.setAProcessingTypeAttribute((EObject)((FixedSizeAggregationImpl)processingType), "frequency", value.intValue());
            }
            if (processingTypeProperty.equals(NUMBER_OF_MEASUREMENTS)) {
                this.editor.setAProcessingTypeAttribute((EObject)((FixedSizeAggregationImpl)processingType), "numberOfMeasurements", value.intValue());
            }
        } else {
            if (processingTypeProperty.equals(FREQUENCY)) {
                ((FixedSizeAggregationImpl)processingType).setFrequency(value.intValue());
            }
            if (processingTypeProperty.equals(NUMBER_OF_MEASUREMENTS)) {
                ((FixedSizeAggregationImpl)processingType).setNumberOfMeasurements(value.intValue());
            }
        }
    }

    public Number getAProcessingType(MeasurementSpecification measurementSpecification, String processingTypeProperty) {
        ProcessingType processingType = measurementSpecification.getProcessingType();
        if (processingType instanceof FixedSizeAggregationImpl) {
            if (processingTypeProperty.equals(FREQUENCY)) {
                return ((FixedSizeAggregationImpl)processingType).getFrequency();
            }
            if (processingTypeProperty.equals(NUMBER_OF_MEASUREMENTS)) {
                return ((FixedSizeAggregationImpl)processingType).getNumberOfMeasurements();
            }
        } else if (processingType instanceof TimeDrivenImpl) {
            if (processingTypeProperty.equals(WINDOW_INCREMENT)) {
                return ((TimeDrivenImpl)processingType).getWindowIncrement();
            }
            if (processingTypeProperty.equals(WINDOW_LENGTH)) {
                return ((TimeDrivenImpl)processingType).getWindowLength();
            }
        } else if (processingType instanceof VariableSizeAggregationImpl) {
            if (processingTypeProperty.equals(FREQUENCY)) {
                return ((VariableSizeAggregationImpl)processingType).getFrequency();
            }
            if (processingTypeProperty.equals(RETROSPECTION_LENGTH)) {
                return ((VariableSizeAggregationImpl)processingType).getRetrospectionLength();
            }
        }
        return null;
    }

    public String getProcessingTypeString(ProcessingType aProcessingType) {
        String result;
        if (aProcessingType instanceof FeedThroughImpl) {
            result = FEED_THROUGH;
        } else if (aProcessingType instanceof FixedSizeAggregationImpl) {
            result = FIXED_SIZE_AGGREGATION;
        } else if (aProcessingType instanceof TimeDrivenImpl) {
            result = aProcessingType instanceof TimeDrivenAggregationImpl ? TIME_DRIVEN_AGGREGATION : TIME_DRIVEN;
        } else if (aProcessingType instanceof VariableSizeAggregationImpl) {
            result = VARIABLE_SIZE_AGGREGATION;
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

