/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.dataprovider.UnselectedMetricSpecificationsProvider;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;

public class MetricDescriptionSelectionWizardModel
implements WizardModel {
    private static final String STANDARD_INFORMATION_MESSAGE = "Please select all Metrics which should be measured.";
    private static final String NO_METRIC_SELECTED_MEASSAGE = "There is currently no Metric selected. In order to get Simulation results you have to select at least one Metric.";
    private static final String METRIC_SELECTION_TITEL = "Select Metrics";
    private Monitor usedMetricsMonitor;
    private Monitor unusedMetricsMonitor;
    private UnselectedMetricSpecificationsProvider provider = new UnselectedMetricSpecificationsProvider();
    private boolean isEditing;

    public MetricDescriptionSelectionWizardModel(Monitor monitor, boolean isEditing) {
        this.usedMetricsMonitor = monitor;
        this.isEditing = isEditing;
        this.unusedMetricsMonitor = MonitorRepositoryFactory.eINSTANCE.createMonitor();
    }

    public void initUnusedMetrics(Monitor usedMonitor, boolean expertMode) {
        this.provider.createMonitorWithMissingMetricDescriptions(usedMonitor, this.unusedMetricsMonitor, expertMode);
    }

    @Override
    public boolean canFinish() {
        return !this.metricListIsEmpty();
    }

    @Override
    public String getInfoText() {
        if (this.metricListIsEmpty()) {
            return NO_METRIC_SELECTED_MEASSAGE;
        }
        return STANDARD_INFORMATION_MESSAGE;
    }

    public Monitor getUnusedMetricsMonitor() {
        return this.unusedMetricsMonitor;
    }

    public Monitor getUsedMetricsMonitor() {
        return this.usedMetricsMonitor;
    }

    public void addMeasurementSpecification(MeasurementSpecification selectedMeasurementSpecification) {
        if (selectedMeasurementSpecification != null) {
            this.provider.moveMeasurementSpecificationToMonitor(selectedMeasurementSpecification, this.usedMetricsMonitor, this.isEditing);
        }
    }

    public void removeMeasurementSpecification(MeasurementSpecification selectedMeasurementSpecification) {
        if (selectedMeasurementSpecification != null) {
            this.provider.removeMeasurementSpecificationFromMonitor(selectedMeasurementSpecification, this.unusedMetricsMonitor, this.isEditing);
        }
    }

    public void addAllMetricDescriptions() {
        this.provider.moveAllMeasurementSpecificationsToMonitor(this.unusedMetricsMonitor, this.usedMetricsMonitor, this.isEditing);
    }

    public void removeAllMetricDescriptions() {
        this.provider.removeAllMeasurementSpecificationsFromMonitor(this.usedMetricsMonitor, this.unusedMetricsMonitor, this.isEditing);
    }

    public void moveAllSuggested() {
        this.provider.moveSuggestedMeasurementSpecificationsToMonitor(this.unusedMetricsMonitor, this.usedMetricsMonitor, this.isEditing);
    }

    public void switchTriggerSelfAdapting(MeasurementSpecification mspec) {
        if (this.isEditing) {
            ResourceEditorImpl.getInstance().changeTriggersSelfAdapting(mspec);
        } else {
            mspec.setTriggersSelfAdaptations(!mspec.isTriggersSelfAdaptations());
        }
    }

    private boolean metricListIsEmpty() {
        return this.usedMetricsMonitor.getMeasurementSpecifications().isEmpty();
    }

    @Override
    public String getTitleText() {
        return METRIC_SELECTION_TITEL;
    }

    public String getTextualDescriptionForMetricDescription(MeasurementSpecification aMeasurementSpecification) {
        return this.provider.provideTextualDescriptionForMetricDescription(aMeasurementSpecification.getMetricDescription());
    }
}

