/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.extensionpoint.evaluation;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.extensionpoint.evaluation.MeasuringPointMetricsCombinations;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.EntryLevelSystemCallMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ExternalCallActionMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.LinkingResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointPackage;
import org.palladiosimulator.pcmmeasuringpoint.ResourceContainerMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ResourceEnvironmentMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SubSystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateExtensions {
    private static final String EXTENSION_POINT_ID = "org.palladiosimulator.measurementsui.extensionpoint.definition.measuringPointMetricsWorkingCombinations";
    private Resource metricDescriptionConstants;
    private static final String PATHMAP_METRIC_SPEC_MODELS_COMMON_METRICS_METRICSPEC = "pathmap://METRIC_SPEC_MODELS/commonMetrics.metricspec";
    private static final Map<?, ?> OPTIONS = Collections.emptyMap();
    private final MeasuringPointMetricsCombinations measuringPointMetricsCombinations = new MeasuringPointMetricsCombinations();
    private static final Logger logger = LoggerFactory.getLogger(EvaluateExtensions.class);

    public EvaluateExtensions() {
        this.loadMetricDescriptionConstants();
    }

    public MeasuringPointMetricsCombinations getMeasuringPointmetricsCombinations() {
        return this.measuringPointMetricsCombinations;
    }

    private void loadMetricDescriptionConstants() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.metricDescriptionConstants = resourceSet.createResource(URI.createURI((String)PATHMAP_METRIC_SPEC_MODELS_COMMON_METRICS_METRICSPEC, (boolean)true));
        try {
            this.metricDescriptionConstants.load(OPTIONS);
        }
        catch (IOException e) {
            logger.warn("IOException when loading metric description constants from {0}. Stacktrace: {1}", (Object)PATHMAP_METRIC_SPEC_MODELS_COMMON_METRICS_METRICSPEC, (Object)e.getMessage());
        }
    }

    private Optional<MeasuringPoint> getMeasuringPoint(String measuringPointClassName) {
        EObject measuringPointInstance;
        EClassifier classifier = PcmmeasuringpointPackage.eINSTANCE.getEClassifier(measuringPointClassName);
        if (classifier instanceof EClass && (measuringPointInstance = PcmmeasuringpointFactory.eINSTANCE.create((EClass)classifier)) instanceof MeasuringPoint) {
            return Optional.of((MeasuringPoint)measuringPointInstance);
        }
        return Optional.empty();
    }

    private Optional<MetricDescription> getMetricDescription(String id) {
        EObject metricDescriptionInstance = this.metricDescriptionConstants.getEObject(id);
        if (metricDescriptionInstance instanceof MetricDescription) {
            return Optional.of((MetricDescription)metricDescriptionInstance);
        }
        return Optional.empty();
    }

    public void loadExtensions() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String measuringPointClassname = configurationElement.getAttribute("MeasuringPoint");
            String metricDescriptionId = configurationElement.getAttribute("MetricDescription");
            String suggestedMetric = configurationElement.getAttribute("SuggestedMetricDescription");
            if (this.getMeasuringPoint(measuringPointClassname).isPresent() && this.getMetricDescription(metricDescriptionId).isPresent() && (suggestedMetric.equalsIgnoreCase("true") || suggestedMetric.equalsIgnoreCase("false"))) {
                MeasuringPoint measuringPointObject = this.getMeasuringPoint(measuringPointClassname).get();
                MetricDescription metricDescriptionObject = this.getMetricDescription(metricDescriptionId).get();
                boolean suggestedMetricBoolean = Boolean.parseBoolean(suggestedMetric);
                PcmmeasuringpointSwitch<MeasuringPoint> measuringPointSwitch = this.getPcmMeasuringPointSwitch(metricDescriptionObject, suggestedMetricBoolean);
                measuringPointSwitch.doSwitch((EObject)measuringPointObject);
            }
            ++n2;
        }
    }

    private PcmmeasuringpointSwitch<MeasuringPoint> getPcmMeasuringPointSwitch(final MetricDescription metricDescription, final boolean suggestedMetric) {
        return new PcmmeasuringpointSwitch<MeasuringPoint>(){

            public MeasuringPoint caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getActiveResourceMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseAssemblyOperationMeasuringPoint(AssemblyOperationMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getAssemblyOperationMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseAssemblyPassiveResourceMeasuringPoint(AssemblyPassiveResourceMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getAssemblyPassiveResourceMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseEntryLevelSystemCallMeasuringPoint(EntryLevelSystemCallMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getEntryLevelSystemCallMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseExternalCallActionMeasuringPoint(ExternalCallActionMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getExternalCallActionMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseLinkingResourceMeasuringPoint(LinkingResourceMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getLinkingResourceMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseResourceContainerMeasuringPoint(ResourceContainerMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getResourceContainerMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseResourceEnvironmentMeasuringPoint(ResourceEnvironmentMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getResourceEnvironmentMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseSubSystemOperationMeasuringPoint(SubSystemOperationMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getSubSystemOperationMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseSystemOperationMeasuringPoint(SystemOperationMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getSystemOperationMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }

            public MeasuringPoint caseUsageScenarioMeasuringPoint(UsageScenarioMeasuringPoint object) {
                EvaluateExtensions.this.measuringPointMetricsCombinations.addMetricDescriptionToMap(EvaluateExtensions.this.measuringPointMetricsCombinations.getUsageScenarioMeasuringPointMetrics(), metricDescription, suggestedMetric);
                return object;
            }
        };
    }
}

