/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.abstractviewer;

import com.google.inject.Injector;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.edit.ui.dnd.ViewerDragAndDropHelper;
import org.eclipse.emf.parsley.menus.ViewerContextMenuHelper;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public abstract class ComponentViewer {
    protected Injector injector;
    protected Resource resource;
    protected EditingDomain editingDomain;
    protected EObject modelRepository;

    public ComponentViewer(Composite parent, EObject modelRepository) {
        this.modelRepository = modelRepository;
        this.initInjector();
        this.initEditingDomain();
        this.initParsley(parent);
        this.initContextMenu();
        this.initDragAndDrop();
    }

    protected abstract void initInjector();

    protected Optional<EObject> getModelRepository() {
        if (this.modelRepository != null) {
            return Optional.of(this.modelRepository);
        }
        return Optional.empty();
    }

    public void setModelRepository(EObject modelRepository) {
        this.modelRepository = modelRepository;
    }

    protected abstract void initParsley(Composite var1);

    public abstract void update();

    protected void initEditingDomain() {
        this.getModelRepository().ifPresent(modelRepository -> {
            EditingDomain editingDomain = this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)modelRepository);
        });
    }

    public abstract StructuredViewer getViewer();

    protected Resource updateResource(EObject model) {
        ResourceLoader resourceLoader = (ResourceLoader)this.injector.getInstance(ResourceLoader.class);
        this.resource = resourceLoader.getResource(this.editingDomain, model.eResource().getURI()).getResource();
        return this.resource;
    }

    protected void initDragAndDrop() {
        ViewerDragAndDropHelper dragAndDropHelper = (ViewerDragAndDropHelper)this.injector.getInstance(ViewerDragAndDropHelper.class);
        dragAndDropHelper.addDragAndDrop(this.getViewer(), this.editingDomain);
    }

    protected void initContextMenu() {
        ViewerContextMenuHelper contextMenuHelper = (ViewerContextMenuHelper)this.injector.getInstance(ViewerContextMenuHelper.class);
        contextMenuHelper.addViewerContextMenu((Viewer)this.getViewer(), this.editingDomain);
    }
}

