/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.main;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.measurementsui.dataprovider.StandardSetCreationProvider;
import org.palladiosimulator.measurementsui.wizard.pages.StandardSetCreationSelectionWizardPage;
import org.palladiosimulator.measurementsui.wizard.pages.StandardSetMeasuringPointSelectionWizardPage;
import org.palladiosimulator.monitorrepository.Monitor;

public class StandardSetWizard
extends Wizard {
    private StandardSetCreationSelectionWizardPage standardSetChoiceWizardPage;
    private StandardSetMeasuringPointSelectionWizardPage measuringPointSelectionWizardPage;
    private ResourceEditorImpl editor;
    private DataApplication dataApplication;
    private PropertyChangeSupport changes = new PropertyChangeSupport((Object)this);
    private static final String WINDOW_TITLE = "Create a standard set";
    private static final String STANDARD_SET_CHOICE_MESSAGE = "Select which standard set should be created.";
    private static final String SELECTION_PAGE_MESSAGE = "Select all monitors which should be created.";

    public StandardSetCreationSelectionWizardPage getPage1() {
        return this.standardSetChoiceWizardPage;
    }

    public void setPage1(StandardSetCreationSelectionWizardPage page1) {
        this.standardSetChoiceWizardPage = page1;
    }

    public StandardSetMeasuringPointSelectionWizardPage getPage2() {
        return this.measuringPointSelectionWizardPage;
    }

    public void setPage2(StandardSetMeasuringPointSelectionWizardPage page2) {
        this.measuringPointSelectionWizardPage = page2;
    }

    public StandardSetWizard() {
        this.editor = ResourceEditorImpl.getInstance();
        this.dataApplication = DataApplication.getInstance();
        this.setWindowTitle(WINDOW_TITLE);
        this.standardSetChoiceWizardPage = new StandardSetCreationSelectionWizardPage(STANDARD_SET_CHOICE_MESSAGE);
        this.measuringPointSelectionWizardPage = new StandardSetMeasuringPointSelectionWizardPage(SELECTION_PAGE_MESSAGE);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.standardSetChoiceWizardPage);
        this.addPage((IWizardPage)this.measuringPointSelectionWizardPage);
    }

    public boolean performFinish() {
        StandardSetCreationProvider provider = new StandardSetCreationProvider();
        if (this.measuringPointSelectionWizardPage.isLoadMonitorAndMeasuringpoint()) {
            Object[] tempmonitor = this.measuringPointSelectionWizardPage.getViewer().getCheckedElements();
            Monitor[] monitors = new Monitor[tempmonitor.length];
            System.arraycopy(tempmonitor, 0, monitors, 0, tempmonitor.length);
            provider.addMetricDescriptionsToAllMonitors(monitors);
            Monitor[] monitorArray = monitors;
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                Monitor monitor = monitorArray[n2];
                if (!monitor.getMeasurementSpecifications().isEmpty()) {
                    this.editor.addMonitorToRepository((EObject)this.dataApplication.getMonitorRepository(), (EObject)monitor);
                    this.editor.addMeasuringPointToRepository((EObject)this.dataApplication.getModelAccessor().getMeasuringPointRepositoryList().get(0), (EObject)monitor.getMeasuringPoint());
                    this.editor.setMeasuringPointToMonitor((EObject)monitor, monitor.getMeasuringPoint());
                }
                ++n2;
            }
        } else {
            Object[] objectArray = this.measuringPointSelectionWizardPage.getViewer().getCheckedElements();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object tempmeasuringpoint = objectArray[n3];
                MeasuringPoint measuringpoint = (MeasuringPoint)tempmeasuringpoint;
                this.editor.addMeasuringPointToRepository((EObject)this.dataApplication.getModelAccessor().getMeasuringPointRepositoryList().get(0), (EObject)measuringpoint);
                ++n3;
            }
        }
        this.changes.firePropertyChange("save", 1, 2);
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() != this.standardSetChoiceWizardPage;
    }
}

