/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.handlers.labelprovider;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.palladiosimulator.measurementsui.wizardmodel.pages.ProcessingTypeSelectionWizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.ProcessingType;

public class ProcessingTypeSelectionLabelProvider
implements ITableLabelProvider {
    private ProcessingTypeSelectionWizardModel processingTypeSelectionWizardModel;

    public ProcessingTypeSelectionLabelProvider(ProcessingTypeSelectionWizardModel processingTypeSelectionWizardModel) {
        this.processingTypeSelectionWizardModel = processingTypeSelectionWizardModel;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
        if (columnIndex == 0) {
            result = measurementSpecification.getMetricDescription().getName();
        } else if (columnIndex == 1) {
            result = this.processingTypeSelectionWizardModel.getStringOfProcessingType(measurementSpecification.getProcessingType());
        } else if (columnIndex == 2) {
            result = this.getLabelProperty1(result, measurementSpecification);
        } else if (columnIndex == 3) {
            result = this.getLabelProperty2(result, measurementSpecification);
        }
        return result;
    }

    private String getLabelProperty1(String result, MeasurementSpecification measurementSpecification) {
        ProcessingType selectedProcessingType = measurementSpecification.getProcessingType();
        String selectedProcessingTypeString = this.processingTypeSelectionWizardModel.getStringOfProcessingType(selectedProcessingType);
        List processingTypeProperties = this.processingTypeSelectionWizardModel.fieldsForThisProcessingType(selectedProcessingTypeString);
        if (!processingTypeProperties.isEmpty()) {
            result = String.valueOf(result) + (String)processingTypeProperties.get(0) + ": ";
            result = String.valueOf(result) + this.processingTypeSelectionWizardModel.getAProccesingTypeAttribute(measurementSpecification, (String)processingTypeProperties.get(0));
        } else {
            result = String.valueOf(result) + "-";
        }
        return result;
    }

    private String getLabelProperty2(String result, MeasurementSpecification measurementSpecification) {
        ProcessingType selectedProcessingType = measurementSpecification.getProcessingType();
        String selectedProcessingTypeString = this.processingTypeSelectionWizardModel.getStringOfProcessingType(selectedProcessingType);
        List processingTypeProperties = this.processingTypeSelectionWizardModel.fieldsForThisProcessingType(selectedProcessingTypeString);
        if (processingTypeProperties.size() > 1) {
            result = String.valueOf(result) + (String)processingTypeProperties.get(1) + ": ";
            result = String.valueOf(result) + this.processingTypeSelectionWizardModel.getAProccesingTypeAttribute(measurementSpecification, (String)processingTypeProperties.get(1));
        } else {
            result = String.valueOf(result) + "-";
        }
        return result;
    }
}

