/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.palladiosimulator.measurementsui.wizard.handlers.MetricDescriptionSelectionCheckboxCellModifier;
import org.palladiosimulator.measurementsui.wizard.viewer.AvailableMetricDescriptionSelectionViewer;
import org.palladiosimulator.measurementsui.wizard.viewer.SelectedMetricDescriptionSelectionViewer;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MetricDescriptionSelectionWizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;

public class MetricDescriptionSelectionWizardPage
extends WizardPage {
    private static final String CHECKBOX_UNCHECKED = "\u2610";
    private static final String CHECKBOX_CHECKED = "\u2611";
    private Button expertMode;
    private MetricDescriptionSelectionWizardModel metricDescriptionSelectionWizardModel;

    public MetricDescriptionSelectionWizardPage(MetricDescriptionSelectionWizardModel metricDescriptionSelectionWizardModel) {
        super("wizardPage");
        this.metricDescriptionSelectionWizardModel = metricDescriptionSelectionWizardModel;
        this.setTitle(metricDescriptionSelectionWizardModel.getTitleText());
        this.setDescription(metricDescriptionSelectionWizardModel.getInfoText());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layoutParentContainer = new GridLayout();
        layoutParentContainer.numColumns = 3;
        layoutParentContainer.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layoutParentContainer);
        TableViewer tableViewerLeft = this.initLeftTableViewer(container);
        Composite compositeMiddle = this.initMiddleSubComposite(container);
        TableViewer tableViewerRight = this.initRightTableViewer(container);
        this.addButtons(tableViewerLeft, compositeMiddle, tableViewerRight);
        this.setPageComplete(true);
        this.setControl((Control)container);
    }

    private TableViewer initLeftTableViewer(Composite container) {
        Composite compositeLeft = new Composite(container, 0);
        FillLayout fillLayoutLeft = new FillLayout();
        AvailableMetricDescriptionSelectionViewer selectMeasurementsViewerLeft = new AvailableMetricDescriptionSelectionViewer(compositeLeft, this.metricDescriptionSelectionWizardModel.getUnusedMetricsMonitor());
        TableViewer tableViewerLeft = (TableViewer)selectMeasurementsViewerLeft.getViewer();
        tableViewerLeft.getTable().setHeaderBackground(new Color((Device)Display.getCurrent(), 210, 210, 210));
        this.setLabelProvider(tableViewerLeft);
        this.updateMessageAccordingToSelectedMeasuringPoint(tableViewerLeft);
        compositeLeft.setLayout((Layout)fillLayoutLeft);
        compositeLeft.setLayoutData((Object)new GridData(4, 4, true, true));
        LocalSelectionTransfer transfer = this.addDrag(tableViewerLeft);
        boolean dragAndDropfromLeftToRight = false;
        this.addDrop(tableViewerLeft, transfer, dragAndDropfromLeftToRight);
        return tableViewerLeft;
    }

    private Composite initMiddleSubComposite(Composite container) {
        Composite compositeMiddle = new Composite(container, 0);
        FillLayout fillLayoutMiddle = new FillLayout();
        fillLayoutMiddle.type = 0x1000000;
        fillLayoutMiddle.marginWidth = 40;
        fillLayoutMiddle.spacing = 10;
        compositeMiddle.setLayout((Layout)fillLayoutMiddle);
        return compositeMiddle;
    }

    private TableViewer initRightTableViewer(Composite container) {
        Composite compositeRight = new Composite(container, 0);
        FillLayout fillLayoutRight = new FillLayout();
        SelectedMetricDescriptionSelectionViewer emptySelectMeasurementsViewerRight = new SelectedMetricDescriptionSelectionViewer(compositeRight, this.metricDescriptionSelectionWizardModel.getUsedMetricsMonitor());
        TableViewer tableViewerRight = (TableViewer)emptySelectMeasurementsViewerRight.getViewer();
        tableViewerRight.getTable().setHeaderBackground(new Color((Device)Display.getCurrent(), 210, 210, 210));
        this.setLabelProvider(tableViewerRight);
        this.updateMessageAccordingToSelectedMeasuringPoint(tableViewerRight);
        compositeRight.setLayout((Layout)fillLayoutRight);
        compositeRight.setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewerRight.getTable().getColumn(1).setWidth(125);
        this.setCellEditor(tableViewerRight);
        LocalSelectionTransfer transfer = this.addDrag(tableViewerRight);
        boolean dragAndDropfromLeftToRight = true;
        this.addDrop(tableViewerRight, transfer, dragAndDropfromLeftToRight);
        return tableViewerRight;
    }

    private void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String result = "";
                MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
                if (columnIndex == 1) {
                    result = measurementSpecification.isTriggersSelfAdaptations() ? MetricDescriptionSelectionWizardPage.CHECKBOX_CHECKED : MetricDescriptionSelectionWizardPage.CHECKBOX_UNCHECKED;
                    return result;
                }
                result = measurementSpecification.getMetricDescription().getName();
                return result;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
    }

    private void setCellEditor(TableViewer tableViewer) {
        CellEditor[] cellEditor = new CellEditor[]{null, new CheckboxCellEditor((Composite)tableViewer.getTable())};
        tableViewer.setCellEditors(cellEditor);
        String[] columnNames = new String[]{"Selected", "Self Adaptive"};
        tableViewer.setColumnProperties(columnNames);
        tableViewer.setCellModifier((ICellModifier)new MetricDescriptionSelectionCheckboxCellModifier(tableViewer, this.metricDescriptionSelectionWizardModel));
    }

    private LocalSelectionTransfer addDrag(final TableViewer tableViewer) {
        final LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        DragSourceAdapter dragAdapter = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                transfer.setSelection((ISelection)new StructuredSelection((Object[])tableViewer.getTable().getSelection()));
            }
        };
        DragSource dragSource = new DragSource((Control)tableViewer.getTable(), 3);
        dragSource.setTransfer(new Transfer[]{transfer});
        dragSource.addDragListener((DragSourceListener)dragAdapter);
        return transfer;
    }

    private void addDrop(TableViewer tableViewer, final LocalSelectionTransfer transfer, final boolean dragAndDropfromLeftToRight) {
        DropTargetAdapter dropAdapter = new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                StructuredSelection droppedSelection = (StructuredSelection)transfer.getSelection();
                for (Object currentElement : droppedSelection.toList()) {
                    TableItem tableItem = (TableItem)currentElement;
                    MeasurementSpecification measurement = (MeasurementSpecification)tableItem.getData();
                    if (dragAndDropfromLeftToRight) {
                        MetricDescriptionSelectionWizardPage.this.metricDescriptionSelectionWizardModel.addMeasurementSpecification(measurement);
                        continue;
                    }
                    MetricDescriptionSelectionWizardPage.this.metricDescriptionSelectionWizardModel.removeMeasurementSpecification(measurement);
                }
                MetricDescriptionSelectionWizardPage.this.getContainer().updateButtons();
            }
        };
        DropTarget dropTarget = new DropTarget((Control)tableViewer.getTable(), 3);
        dropTarget.setTransfer(new Transfer[]{transfer});
        dropTarget.addDropListener((DropTargetListener)dropAdapter);
    }

    private void addButtons(TableViewer tableViewerLeft, Composite compositeMiddle, TableViewer tableViewerRight) {
        Button rightOne = new Button(compositeMiddle, 0);
        rightOne.setText("Add >");
        rightOne.addListener(13, e -> {
            IStructuredSelection selection = tableViewerLeft.getStructuredSelection();
            for (Object currentElement : selection.toList()) {
                MeasurementSpecification measurement = (MeasurementSpecification)currentElement;
                this.metricDescriptionSelectionWizardModel.addMeasurementSpecification(measurement);
                this.updatePageDescription();
            }
            this.getContainer().updateButtons();
        });
        Button leftOne = new Button(compositeMiddle, 0);
        leftOne.setText("< Remove");
        leftOne.addListener(13, e -> {
            IStructuredSelection selection = tableViewerRight.getStructuredSelection();
            for (Object currentElement : selection.toList()) {
                MeasurementSpecification measurement = (MeasurementSpecification)currentElement;
                this.metricDescriptionSelectionWizardModel.removeMeasurementSpecification(measurement);
                this.updatePageDescription();
            }
            this.getContainer().updateButtons();
        });
        Button rightAll = new Button(compositeMiddle, 8);
        rightAll.setText("Add All >>");
        rightAll.addListener(13, e -> {
            this.metricDescriptionSelectionWizardModel.addAllMetricDescriptions();
            this.updatePageDescription();
            this.getContainer().updateButtons();
        });
        Button leftAll = new Button(compositeMiddle, 0);
        leftAll.setText("<< Remove All");
        leftAll.addListener(13, e -> {
            this.metricDescriptionSelectionWizardModel.removeAllMetricDescriptions();
            this.updatePageDescription();
            this.getContainer().updateButtons();
        });
        this.addLabelForSpacingButtons(compositeMiddle);
        Button addSuggestion = new Button(compositeMiddle, 1024);
        addSuggestion.setText("Add Suggestions >");
        addSuggestion.setToolTipText("Adds a list of suggested Metrics");
        addSuggestion.addListener(13, e -> {
            this.metricDescriptionSelectionWizardModel.moveAllSuggested();
            this.updatePageDescription();
            this.getContainer().updateButtons();
        });
        this.expertMode = new Button(compositeMiddle, 32);
        this.expertMode.setText("Show all Metric Descriptions");
        this.expertMode.setToolTipText("Expert Mode: Can lead to invalid simulations!");
        this.expertMode.addListener(13, e -> {
            this.metricDescriptionSelectionWizardModel.initUnusedMetrics(this.metricDescriptionSelectionWizardModel.getUsedMetricsMonitor(), this.expertMode.getSelection());
            this.updatePageDescription();
            this.getContainer().updateButtons();
        });
    }

    private void addLabelForSpacingButtons(Composite compositeMiddle) {
        Label emptyLabelForSpacing = new Label(compositeMiddle, 0);
        emptyLabelForSpacing.setText(" ");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.metricDescriptionSelectionWizardModel.initUnusedMetrics(this.metricDescriptionSelectionWizardModel.getUsedMetricsMonitor(), this.expertMode.getSelection());
        }
        super.setVisible(visible);
    }

    private void showMessage(MeasurementSpecification aMSpec) {
        this.setMessage(this.metricDescriptionSelectionWizardModel.getTextualDescriptionForMetricDescription(aMSpec));
    }

    private void updatePageDescription() {
        this.setMessage(this.metricDescriptionSelectionWizardModel.getInfoText());
    }

    private void updateMessageAccordingToSelectedMeasuringPoint(TableViewer thisTableViewer) {
        thisTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                if (e.item != null && (item = (TableItem)e.item).getData() instanceof MeasurementSpecification) {
                    MetricDescriptionSelectionWizardPage.this.showMessage((MeasurementSpecification)item.getData());
                }
            }
        });
    }

    public void performHelp() {
        Program.launch((String)"https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#Metric_Description_Selection_Page");
    }
}

