/**
 */
package org.palladiosimulator.monitorrepository.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;

import org.palladiosimulator.monitorrepository.util.MonitorRepositoryAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MonitorRepositoryItemProviderAdapterFactory extends MonitorRepositoryAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(MonitorrepositoryEditPlugin.INSTANCE, MonitorRepositoryPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MonitorRepositoryItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.MonitorRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MonitorRepositoryItemProvider monitorRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.MonitorRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMonitorRepositoryAdapter()
	{
		if (monitorRepositoryItemProvider == null)
		{
			monitorRepositoryItemProvider = new MonitorRepositoryItemProvider(this);
		}

		return monitorRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.Monitor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MonitorItemProvider monitorItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.Monitor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMonitorAdapter()
	{
		if (monitorItemProvider == null)
		{
			monitorItemProvider = new MonitorItemProvider(this);
		}

		return monitorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.MeasurementSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MeasurementSpecificationItemProvider measurementSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.MeasurementSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMeasurementSpecificationAdapter()
	{
		if (measurementSpecificationItemProvider == null)
		{
			measurementSpecificationItemProvider = new MeasurementSpecificationItemProvider(this);
		}

		return measurementSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.ArithmeticMean} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArithmeticMeanItemProvider arithmeticMeanItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.ArithmeticMean}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArithmeticMeanAdapter()
	{
		if (arithmeticMeanItemProvider == null)
		{
			arithmeticMeanItemProvider = new ArithmeticMeanItemProvider(this);
		}

		return arithmeticMeanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.HarmonicMean} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HarmonicMeanItemProvider harmonicMeanItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.HarmonicMean}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHarmonicMeanAdapter()
	{
		if (harmonicMeanItemProvider == null)
		{
			harmonicMeanItemProvider = new HarmonicMeanItemProvider(this);
		}

		return harmonicMeanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.GeometricMean} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeometricMeanItemProvider geometricMeanItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.GeometricMean}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeometricMeanAdapter()
	{
		if (geometricMeanItemProvider == null)
		{
			geometricMeanItemProvider = new GeometricMeanItemProvider(this);
		}

		return geometricMeanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.Median} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MedianItemProvider medianItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.Median}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMedianAdapter()
	{
		if (medianItemProvider == null)
		{
			medianItemProvider = new MedianItemProvider(this);
		}

		return medianItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.FixedSizeAggregation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FixedSizeAggregationItemProvider fixedSizeAggregationItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.FixedSizeAggregation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFixedSizeAggregationAdapter()
	{
		if (fixedSizeAggregationItemProvider == null)
		{
			fixedSizeAggregationItemProvider = new FixedSizeAggregationItemProvider(this);
		}

		return fixedSizeAggregationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.TimeDrivenAggregation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeDrivenAggregationItemProvider timeDrivenAggregationItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.TimeDrivenAggregation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeDrivenAggregationAdapter()
	{
		if (timeDrivenAggregationItemProvider == null)
		{
			timeDrivenAggregationItemProvider = new TimeDrivenAggregationItemProvider(this);
		}

		return timeDrivenAggregationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.TimeDriven} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeDrivenItemProvider timeDrivenItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.TimeDriven}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeDrivenAdapter()
	{
		if (timeDrivenItemProvider == null)
		{
			timeDrivenItemProvider = new TimeDrivenItemProvider(this);
		}

		return timeDrivenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.VariableSizeAggregation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableSizeAggregationItemProvider variableSizeAggregationItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.VariableSizeAggregation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableSizeAggregationAdapter()
	{
		if (variableSizeAggregationItemProvider == null)
		{
			variableSizeAggregationItemProvider = new VariableSizeAggregationItemProvider(this);
		}

		return variableSizeAggregationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.monitorrepository.FeedThrough} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeedThroughItemProvider feedThroughItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.monitorrepository.FeedThrough}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeedThroughAdapter()
	{
		if (feedThroughItemProvider == null)
		{
			feedThroughItemProvider = new FeedThroughItemProvider(this);
		}

		return feedThroughItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders()
	{
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain)
	{
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator()
	{
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose()
	{
		if (monitorRepositoryItemProvider != null) monitorRepositoryItemProvider.dispose();
		if (monitorItemProvider != null) monitorItemProvider.dispose();
		if (measurementSpecificationItemProvider != null) measurementSpecificationItemProvider.dispose();
		if (arithmeticMeanItemProvider != null) arithmeticMeanItemProvider.dispose();
		if (harmonicMeanItemProvider != null) harmonicMeanItemProvider.dispose();
		if (geometricMeanItemProvider != null) geometricMeanItemProvider.dispose();
		if (medianItemProvider != null) medianItemProvider.dispose();
		if (fixedSizeAggregationItemProvider != null) fixedSizeAggregationItemProvider.dispose();
		if (timeDrivenAggregationItemProvider != null) timeDrivenAggregationItemProvider.dispose();
		if (timeDrivenItemProvider != null) timeDrivenItemProvider.dispose();
		if (variableSizeAggregationItemProvider != null) variableSizeAggregationItemProvider.dispose();
		if (feedThroughItemProvider != null) feedThroughItemProvider.dispose();
	}

}
