/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.map.impl;

import java.util.Map;
import java.util.function.UnaryOperator;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.map.ExponentialSmoothing;
import org.palladiosimulator.monitorrepository.map.MapPackage;
import org.palladiosimulator.monitorrepository.map.impl.MapperImpl;

public class ExponentialSmoothingImplGen
extends MapperImpl
implements ExponentialSmoothing {
    protected static final double SMOOTHING_FACTOR_EDEFAULT = 0.5;
    protected double smoothingFactor = 0.5;
    protected Measure<Double, Quantity> smoothedValue;

    protected ExponentialSmoothingImplGen() {
    }

    @Override
    protected EClass eStaticClass() {
        return MapPackage.Literals.EXPONENTIAL_SMOOTHING;
    }

    @Override
    public double getSmoothingFactor() {
        return this.smoothingFactor;
    }

    @Override
    public void setSmoothingFactor(double newSmoothingFactor) {
        double oldSmoothingFactor = this.smoothingFactor;
        this.smoothingFactor = newSmoothingFactor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldSmoothingFactor, this.smoothingFactor));
        }
    }

    @Override
    public Measure<Double, Quantity> getSmoothedValue() {
        return this.smoothedValue;
    }

    @Override
    public void setSmoothedValue(Measure<Double, Quantity> newSmoothedValue) {
        Measure<Double, Quantity> oldSmoothedValue = this.smoothedValue;
        this.smoothedValue = newSmoothedValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldSmoothedValue, this.smoothedValue));
        }
    }

    @Override
    public UnaryOperator<MeasuringValue> getMappingFunction() {
        return input -> {
            NumericalBaseMetricDescription expectedMetric = (NumericalBaseMetricDescription)this.getMap().getOutputMetricDescription();
            Unit unit = expectedMetric.getDefaultUnit();
            double value = input.getMeasureForMetric((MetricDescription)expectedMetric).doubleValue(unit);
            Measure time = input.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
            double oldValue = this.getSmoothedValue() == null ? 0.0 : this.getSmoothedValue().doubleValue(unit);
            this.setSmoothedValue((Measure<Double, Quantity>)Measure.valueOf((double)(oldValue * (1.0 - this.getSmoothingFactor()) + value * this.getSmoothingFactor()), (Unit)unit));
            return new TupleMeasurement((MetricSetDescription)input.getMetricDesciption(), new Measure[]{time, this.getSmoothedValue()});
        };
    }

    @Override
    public boolean isMetricNumericalBaseMetric(DiagnosticChain chain, Map<?, ?> context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getSmoothingFactor();
            }
            case 3: {
                return this.getSmoothedValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setSmoothingFactor((Double)newValue);
                return;
            }
            case 3: {
                this.setSmoothedValue((Measure<Double, Quantity>)((Measure)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setSmoothingFactor(0.5);
                return;
            }
            case 3: {
                this.setSmoothedValue(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.smoothingFactor != 0.5;
            }
            case 3: {
                return this.smoothedValue != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (smoothingFactor: ");
        result.append(this.smoothingFactor);
        result.append(", smoothedValue: ");
        result.append(this.smoothedValue);
        result.append(')');
        return result.toString();
    }
}

