/**
 */
package org.palladiosimulator.monitorrepository.impl;

import de.uka.ipd.sdq.identifier.IdentifierPackage;

import de.uka.ipd.sdq.probfunction.ProbfunctionPackage;

import de.uka.ipd.sdq.stoex.StoexPackage;

import de.uka.ipd.sdq.units.UnitsPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataPackage;

import org.palladiosimulator.edp2.models.Repository.RepositoryPackage;

import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointPackage;

import org.palladiosimulator.metricspec.MetricSpecPackage;

import org.palladiosimulator.monitorrepository.Aggregation;
import org.palladiosimulator.monitorrepository.ArithmeticMean;
import org.palladiosimulator.monitorrepository.FeedThrough;
import org.palladiosimulator.monitorrepository.FixedSizeAggregation;
import org.palladiosimulator.monitorrepository.GeometricMean;
import org.palladiosimulator.monitorrepository.HarmonicMean;
import org.palladiosimulator.monitorrepository.MeasurementDrivenAggregation;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Median;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.monitorrepository.StatisticalCharacterization;
import org.palladiosimulator.monitorrepository.TimeDriven;
import org.palladiosimulator.monitorrepository.TimeDrivenAggregation;
import org.palladiosimulator.monitorrepository.VariableSizeAggregation;

import org.palladiosimulator.monitorrepository.util.MonitorRepositoryValidator;
import org.palladiosimulator.monitorrepository.util.UtilPackage;

import org.palladiosimulator.monitorrepository.util.impl.UtilPackageImpl;

import org.palladiosimulator.pcm.PcmPackage;

import org.palladiosimulator.pcm.core.entity.EntityPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MonitorRepositoryPackageImpl extends EPackageImpl implements MonitorRepositoryPackage
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass monitorRepositoryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass monitorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass measurementSpecificationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass statisticalCharacterizationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arithmeticMeanEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass harmonicMeanEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass geometricMeanEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass medianEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processingTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass aggregationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass measurementDrivenAggregationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fixedSizeAggregationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass timeDrivenAggregationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass timeDrivenEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass variableSizeAggregationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass feedThroughEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.palladiosimulator.monitorrepository.MonitorRepositoryPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MonitorRepositoryPackageImpl()
	{
		super(eNS_URI, MonitorRepositoryFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link MonitorRepositoryPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MonitorRepositoryPackage init()
	{
		if (isInited) return (MonitorRepositoryPackage)EPackage.Registry.INSTANCE.getEPackage(MonitorRepositoryPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredMonitorRepositoryPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		MonitorRepositoryPackageImpl theMonitorRepositoryPackage = registeredMonitorRepositoryPackage instanceof MonitorRepositoryPackageImpl ? (MonitorRepositoryPackageImpl)registeredMonitorRepositoryPackage : new MonitorRepositoryPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		IdentifierPackage.eINSTANCE.eClass();
		MetricSpecPackage.eINSTANCE.eClass();
		PcmPackage.eINSTANCE.eClass();
		ProbfunctionPackage.eINSTANCE.eClass();
		StoexPackage.eINSTANCE.eClass();
		UnitsPackage.eINSTANCE.eClass();
		ExperimentDataPackage.eINSTANCE.eClass();
		RepositoryPackage.eINSTANCE.eClass();
		MeasuringpointPackage.eINSTANCE.eClass();
		EcorePackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		Object registeredPackage = EPackage.Registry.INSTANCE.getEPackage(UtilPackage.eNS_URI);
		UtilPackageImpl theUtilPackage = (UtilPackageImpl)(registeredPackage instanceof UtilPackageImpl ? registeredPackage : UtilPackage.eINSTANCE);

		// Create package meta-data objects
		theMonitorRepositoryPackage.createPackageContents();
		theUtilPackage.createPackageContents();

		// Initialize created meta-data
		theMonitorRepositoryPackage.initializePackageContents();
		theUtilPackage.initializePackageContents();

		// Register package validator
		EValidator.Registry.INSTANCE.put
			(theMonitorRepositoryPackage,
			 new EValidator.Descriptor()
			 {
				 @Override
				 public EValidator getEValidator()
				 {
					 return MonitorRepositoryValidator.INSTANCE;
				 }
			 });

		// Mark meta-data to indicate it can't be changed
		theMonitorRepositoryPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(MonitorRepositoryPackage.eNS_URI, theMonitorRepositoryPackage);
		return theMonitorRepositoryPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMonitorRepository()
	{
		return monitorRepositoryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMonitorRepository_Monitors()
	{
		return (EReference)monitorRepositoryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMonitor()
	{
		return monitorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMonitor_MeasurementSpecifications()
	{
		return (EReference)monitorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMonitor_MeasuringPoint()
	{
		return (EReference)monitorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMonitor_MonitorRepository()
	{
		return (EReference)monitorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMonitor_Activated()
	{
		return (EAttribute)monitorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMeasurementSpecification()
	{
		return measurementSpecificationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMeasurementSpecification_MetricDescription()
	{
		return (EReference)measurementSpecificationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMeasurementSpecification_Monitor()
	{
		return (EReference)measurementSpecificationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMeasurementSpecification_Name()
	{
		return (EAttribute)measurementSpecificationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMeasurementSpecification_ProcessingType()
	{
		return (EReference)measurementSpecificationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMeasurementSpecification_TriggersSelfAdaptations()
	{
		return (EAttribute)measurementSpecificationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getStatisticalCharacterization()
	{
		return statisticalCharacterizationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getArithmeticMean()
	{
		return arithmeticMeanEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHarmonicMean()
	{
		return harmonicMeanEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGeometricMean()
	{
		return geometricMeanEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMedian()
	{
		return medianEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProcessingType()
	{
		return processingTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProcessingType_MeasurementSpecification()
	{
		return (EReference)processingTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAggregation()
	{
		return aggregationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAggregation_StatisticalCharacterization()
	{
		return (EReference)aggregationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMeasurementDrivenAggregation()
	{
		return measurementDrivenAggregationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMeasurementDrivenAggregation_Frequency()
	{
		return (EAttribute)measurementDrivenAggregationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFixedSizeAggregation()
	{
		return fixedSizeAggregationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFixedSizeAggregation_NumberOfMeasurements()
	{
		return (EAttribute)fixedSizeAggregationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTimeDrivenAggregation()
	{
		return timeDrivenAggregationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTimeDriven()
	{
		return timeDrivenEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTimeDriven_WindowLength()
	{
		return (EAttribute)timeDrivenEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTimeDriven_WindowIncrement()
	{
		return (EAttribute)timeDrivenEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getVariableSizeAggregation()
	{
		return variableSizeAggregationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getVariableSizeAggregation_RetrospectionLength()
	{
		return (EAttribute)variableSizeAggregationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFeedThrough()
	{
		return feedThroughEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MonitorRepositoryFactory getMonitorRepositoryFactory()
	{
		return (MonitorRepositoryFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents()
	{
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		monitorRepositoryEClass = createEClass(MONITOR_REPOSITORY);
		createEReference(monitorRepositoryEClass, MONITOR_REPOSITORY__MONITORS);

		monitorEClass = createEClass(MONITOR);
		createEReference(monitorEClass, MONITOR__MEASUREMENT_SPECIFICATIONS);
		createEReference(monitorEClass, MONITOR__MEASURING_POINT);
		createEReference(monitorEClass, MONITOR__MONITOR_REPOSITORY);
		createEAttribute(monitorEClass, MONITOR__ACTIVATED);

		measurementSpecificationEClass = createEClass(MEASUREMENT_SPECIFICATION);
		createEReference(measurementSpecificationEClass, MEASUREMENT_SPECIFICATION__METRIC_DESCRIPTION);
		createEReference(measurementSpecificationEClass, MEASUREMENT_SPECIFICATION__MONITOR);
		createEAttribute(measurementSpecificationEClass, MEASUREMENT_SPECIFICATION__NAME);
		createEReference(measurementSpecificationEClass, MEASUREMENT_SPECIFICATION__PROCESSING_TYPE);
		createEAttribute(measurementSpecificationEClass, MEASUREMENT_SPECIFICATION__TRIGGERS_SELF_ADAPTATIONS);

		statisticalCharacterizationEClass = createEClass(STATISTICAL_CHARACTERIZATION);

		arithmeticMeanEClass = createEClass(ARITHMETIC_MEAN);

		harmonicMeanEClass = createEClass(HARMONIC_MEAN);

		geometricMeanEClass = createEClass(GEOMETRIC_MEAN);

		medianEClass = createEClass(MEDIAN);

		processingTypeEClass = createEClass(PROCESSING_TYPE);
		createEReference(processingTypeEClass, PROCESSING_TYPE__MEASUREMENT_SPECIFICATION);

		aggregationEClass = createEClass(AGGREGATION);
		createEReference(aggregationEClass, AGGREGATION__STATISTICAL_CHARACTERIZATION);

		measurementDrivenAggregationEClass = createEClass(MEASUREMENT_DRIVEN_AGGREGATION);
		createEAttribute(measurementDrivenAggregationEClass, MEASUREMENT_DRIVEN_AGGREGATION__FREQUENCY);

		fixedSizeAggregationEClass = createEClass(FIXED_SIZE_AGGREGATION);
		createEAttribute(fixedSizeAggregationEClass, FIXED_SIZE_AGGREGATION__NUMBER_OF_MEASUREMENTS);

		timeDrivenAggregationEClass = createEClass(TIME_DRIVEN_AGGREGATION);

		timeDrivenEClass = createEClass(TIME_DRIVEN);
		createEAttribute(timeDrivenEClass, TIME_DRIVEN__WINDOW_LENGTH);
		createEAttribute(timeDrivenEClass, TIME_DRIVEN__WINDOW_INCREMENT);

		variableSizeAggregationEClass = createEClass(VARIABLE_SIZE_AGGREGATION);
		createEAttribute(variableSizeAggregationEClass, VARIABLE_SIZE_AGGREGATION__RETROSPECTION_LENGTH);

		feedThroughEClass = createEClass(FEED_THROUGH);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents()
	{
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		UtilPackage theUtilPackage = (UtilPackage)EPackage.Registry.INSTANCE.getEPackage(UtilPackage.eNS_URI);
		EntityPackage theEntityPackage = (EntityPackage)EPackage.Registry.INSTANCE.getEPackage(EntityPackage.eNS_URI);
		MeasuringpointPackage theMeasuringpointPackage = (MeasuringpointPackage)EPackage.Registry.INSTANCE.getEPackage(MeasuringpointPackage.eNS_URI);
		IdentifierPackage theIdentifierPackage = (IdentifierPackage)EPackage.Registry.INSTANCE.getEPackage(IdentifierPackage.eNS_URI);
		MetricSpecPackage theMetricSpecPackage = (MetricSpecPackage)EPackage.Registry.INSTANCE.getEPackage(MetricSpecPackage.eNS_URI);
		ExperimentDataPackage theExperimentDataPackage = (ExperimentDataPackage)EPackage.Registry.INSTANCE.getEPackage(ExperimentDataPackage.eNS_URI);

		// Add subpackages
		getESubpackages().add(theUtilPackage);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		monitorRepositoryEClass.getESuperTypes().add(theEntityPackage.getEntity());
		monitorEClass.getESuperTypes().add(theEntityPackage.getEntity());
		measurementSpecificationEClass.getESuperTypes().add(theIdentifierPackage.getIdentifier());
		arithmeticMeanEClass.getESuperTypes().add(this.getStatisticalCharacterization());
		harmonicMeanEClass.getESuperTypes().add(this.getStatisticalCharacterization());
		geometricMeanEClass.getESuperTypes().add(this.getStatisticalCharacterization());
		medianEClass.getESuperTypes().add(this.getStatisticalCharacterization());
		processingTypeEClass.getESuperTypes().add(theIdentifierPackage.getIdentifier());
		aggregationEClass.getESuperTypes().add(this.getProcessingType());
		measurementDrivenAggregationEClass.getESuperTypes().add(this.getAggregation());
		fixedSizeAggregationEClass.getESuperTypes().add(this.getMeasurementDrivenAggregation());
		timeDrivenAggregationEClass.getESuperTypes().add(this.getTimeDriven());
		timeDrivenAggregationEClass.getESuperTypes().add(this.getAggregation());
		timeDrivenEClass.getESuperTypes().add(this.getProcessingType());
		variableSizeAggregationEClass.getESuperTypes().add(this.getMeasurementDrivenAggregation());
		feedThroughEClass.getESuperTypes().add(this.getProcessingType());

		// Initialize classes and features; add operations and parameters
		initEClass(monitorRepositoryEClass, MonitorRepository.class, "MonitorRepository", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMonitorRepository_Monitors(), this.getMonitor(), this.getMonitor_MonitorRepository(), "monitors", null, 0, -1, MonitorRepository.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(monitorEClass, Monitor.class, "Monitor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMonitor_MeasurementSpecifications(), this.getMeasurementSpecification(), this.getMeasurementSpecification_Monitor(), "measurementSpecifications", null, 1, -1, Monitor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMonitor_MeasuringPoint(), theMeasuringpointPackage.getMeasuringPoint(), null, "measuringPoint", null, 1, 1, Monitor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMonitor_MonitorRepository(), this.getMonitorRepository(), this.getMonitorRepository_Monitors(), "monitorRepository", null, 1, 1, Monitor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMonitor_Activated(), ecorePackage.getEBoolean(), "activated", "true", 0, 1, Monitor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(measurementSpecificationEClass, MeasurementSpecification.class, "MeasurementSpecification", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMeasurementSpecification_MetricDescription(), theMetricSpecPackage.getMetricDescription(), null, "metricDescription", null, 1, 1, MeasurementSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMeasurementSpecification_Monitor(), this.getMonitor(), this.getMonitor_MeasurementSpecifications(), "monitor", null, 1, 1, MeasurementSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMeasurementSpecification_Name(), ecorePackage.getEString(), "name", "", 0, 1, MeasurementSpecification.class, !IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEReference(getMeasurementSpecification_ProcessingType(), this.getProcessingType(), this.getProcessingType_MeasurementSpecification(), "processingType", null, 1, 1, MeasurementSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMeasurementSpecification_TriggersSelfAdaptations(), ecorePackage.getEBoolean(), "triggersSelfAdaptations", "true", 0, 1, MeasurementSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(statisticalCharacterizationEClass, StatisticalCharacterization.class, "StatisticalCharacterization", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		EOperation op = addEOperation(statisticalCharacterizationEClass, theUtilPackage.getStatisticalCharacterizationAggregator(), "getAggregator", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theMetricSpecPackage.getNumericalBaseMetricDescription(), "expectedDataMetric", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(arithmeticMeanEClass, ArithmeticMean.class, "ArithmeticMean", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		op = addEOperation(arithmeticMeanEClass, theUtilPackage.getStatisticalCharacterizationAggregator(), "getAggregator", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theMetricSpecPackage.getNumericalBaseMetricDescription(), "expectedDataMetric", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(harmonicMeanEClass, HarmonicMean.class, "HarmonicMean", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		op = addEOperation(harmonicMeanEClass, theUtilPackage.getStatisticalCharacterizationAggregator(), "getAggregator", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theMetricSpecPackage.getNumericalBaseMetricDescription(), "expectedDataMetric", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(geometricMeanEClass, GeometricMean.class, "GeometricMean", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		op = addEOperation(geometricMeanEClass, theUtilPackage.getStatisticalCharacterizationAggregator(), "getAggregator", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theMetricSpecPackage.getNumericalBaseMetricDescription(), "expectedDataMetric", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(medianEClass, Median.class, "Median", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		op = addEOperation(medianEClass, theUtilPackage.getStatisticalCharacterizationAggregator(), "getAggregator", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theMetricSpecPackage.getNumericalBaseMetricDescription(), "expectedDataMetric", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(processingTypeEClass, ProcessingType.class, "ProcessingType", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessingType_MeasurementSpecification(), this.getMeasurementSpecification(), this.getMeasurementSpecification_ProcessingType(), "measurementSpecification", null, 1, 1, ProcessingType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(aggregationEClass, Aggregation.class, "Aggregation", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAggregation_StatisticalCharacterization(), this.getStatisticalCharacterization(), null, "statisticalCharacterization", null, 1, 1, Aggregation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(measurementDrivenAggregationEClass, MeasurementDrivenAggregation.class, "MeasurementDrivenAggregation", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMeasurementDrivenAggregation_Frequency(), ecorePackage.getEInt(), "frequency", "1", 1, 1, MeasurementDrivenAggregation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(fixedSizeAggregationEClass, FixedSizeAggregation.class, "FixedSizeAggregation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFixedSizeAggregation_NumberOfMeasurements(), ecorePackage.getEInt(), "numberOfMeasurements", "10", 1, 1, FixedSizeAggregation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(timeDrivenAggregationEClass, TimeDrivenAggregation.class, "TimeDrivenAggregation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(timeDrivenEClass, TimeDriven.class, "TimeDriven", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTimeDriven_WindowLength(), ecorePackage.getEDouble(), "windowLength", "10.0", 0, 1, TimeDriven.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTimeDriven_WindowIncrement(), ecorePackage.getEDouble(), "windowIncrement", "10.0", 0, 1, TimeDriven.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		op = addEOperation(timeDrivenEClass, null, "getWindowLengthAsMeasure", 0, 1, IS_UNIQUE, IS_ORDERED);
		EGenericType g1 = createEGenericType(theExperimentDataPackage.getEJSMeasure());
		EGenericType g2 = createEGenericType(ecorePackage.getEDoubleObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(theUtilPackage.getDuration());
		g1.getETypeArguments().add(g2);
		initEOperation(op, g1);

		op = addEOperation(timeDrivenEClass, null, "getWindowIncrementAsMeasure", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(theExperimentDataPackage.getEJSMeasure());
		g2 = createEGenericType(ecorePackage.getEDoubleObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(theUtilPackage.getDuration());
		g1.getETypeArguments().add(g2);
		initEOperation(op, g1);

		initEClass(variableSizeAggregationEClass, VariableSizeAggregation.class, "VariableSizeAggregation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getVariableSizeAggregation_RetrospectionLength(), ecorePackage.getEDouble(), "retrospectionLength", "10.0", 1, 1, VariableSizeAggregation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		op = addEOperation(variableSizeAggregationEClass, null, "getRetrospectionLengthAsMeasure", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(theExperimentDataPackage.getEJSMeasure());
		g2 = createEGenericType(ecorePackage.getEDoubleObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(theUtilPackage.getDuration());
		g1.getETypeArguments().add(g2);
		initEOperation(op, g1);

		initEClass(feedThroughEClass, FeedThrough.class, "FeedThrough", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/Ecore
		createEcoreAnnotations();
		// http://www.eclipse.org/emf/2002/Ecore/OCL
		createOCLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createEcoreAnnotations()
	{
		String source = "http://www.eclipse.org/emf/2002/Ecore";
		addAnnotation
		  (this,
		   source,
		   new String[]
		   {
			   "invocationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL",
			   "settingDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL",
			   "validationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL"
		   });
		addAnnotation
		  (measurementDrivenAggregationEClass,
		   source,
		   new String[]
		   {
			   "constraints", "frequency"
		   });
		addAnnotation
		  (fixedSizeAggregationEClass,
		   source,
		   new String[]
		   {
			   "constraints", "measNum"
		   });
		addAnnotation
		  (timeDrivenEClass,
		   source,
		   new String[]
		   {
			   "constraints", "windowLength windowIncrement"
		   });
		addAnnotation
		  (variableSizeAggregationEClass,
		   source,
		   new String[]
		   {
			   "constraints", "retroLength"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore/OCL</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createOCLAnnotations()
	{
		String source = "http://www.eclipse.org/emf/2002/Ecore/OCL";
		addAnnotation
		  (getMeasurementSpecification_Name(),
		   source,
		   new String[]
		   {
			   "derivation", "if self.processingType.oclIsKindOf(Aggregation) then self.monitor.entityName + \':\' +self.processingType.toString()+\'(\' + self.processingType.oclAsType(Aggregation).statisticalCharacterization.toString() +\')\' else self.monitor.entityName + \': \' + self.processingType.toString() endif"
		   });
		addAnnotation
		  (measurementDrivenAggregationEClass,
		   source,
		   new String[]
		   {
			   "frequency", "self.frequency > 0"
		   });
		addAnnotation
		  (fixedSizeAggregationEClass,
		   source,
		   new String[]
		   {
			   "measNum", "self.numberOfMeasurements > 0"
		   });
		addAnnotation
		  (timeDrivenEClass,
		   source,
		   new String[]
		   {
			   "windowLength", "self.windowLength > 0.0",
			   "windowIncrement", "self.windowIncrement > 0.0"
		   });
		addAnnotation
		  (variableSizeAggregationEClass,
		   source,
		   new String[]
		   {
			   "retroLength", "self.retrospectionLength > 0.0"
		   });
	}

} //MonitorRepositoryPackageImpl
